import 'package:flutter/material.dart';
import 'package:ovopaymerchant/app/components/card/custom_card.dart';
import 'package:ovopaymerchant/core/utils/util_exporter.dart';
import 'package:skeletonizer/skeletonizer.dart';

class HomeShimmer extends StatelessWidget {
  const HomeShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    return Skeletonizer.zone(
      enabled: true,
      child: Column(
        children: [
          CustomAppCard(
            child: Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    //Wallet
                    Bone.circle(size: Dimensions.space24.h),
                    spaceSide(Dimensions.space8),
                    Expanded(child: Bone.text()),
                    //Qr Code
                    Bone.circle(size: Dimensions.space40.h),
                  ],
                ),
                spaceDown(Dimensions.space25),
                Bone.text(style: TextStyle(fontSize: 35)),
                spaceDown(Dimensions.space20),
                Row(
                  children: [
                    Expanded(child: Bone.text(style: TextStyle(fontSize: 35))),
                    spaceSide(Dimensions.space10),
                    Expanded(child: Bone.text(style: TextStyle(fontSize: 35))),
                  ],
                ),
              ],
            ),
          ),

          // spaceDown(Dimensions.space15),

          // Expanded(child: CustomAppCard(child: TransactionHistoryShimmer()))
        ],
      ),
    );
  }
}
