import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovopaymerchant/app/components/card/custom_card.dart';
import 'package:ovopaymerchant/app/components/image/my_asset_widget.dart';
import 'package:ovopaymerchant/app/components/shimmer/home_shimmer.dart';
import 'package:ovopaymerchant/app/screens/dashboard_screen/controller/home_controller.dart';
import 'package:ovopaymerchant/core/data/services/service_exporter.dart';
import 'package:ovopaymerchant/core/utils/util_exporter.dart';

import 'package:skeletonizer/skeletonizer.dart';

import '../../../../../core/route/route.dart';

class HomeScreenBalanceCard extends StatelessWidget {
  const HomeScreenBalanceCard({super.key, required this.homeController});
  final HomeController homeController;
  @override
  Widget build(BuildContext context) {
    return homeController.isLoading
        ? HomeShimmer()
        : Container(
            padding: const EdgeInsets.all(16.0),
            decoration: BoxDecoration(
              color: MyColor.getPrimaryColor(),
              borderRadius: BorderRadius.circular(Dimensions.cardExtraRadius.r),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Padding(
                  padding: EdgeInsetsDirectional.symmetric(
                    horizontal: Dimensions.space12.w,
                  ),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      //Wallet
                      Row(
                        children: [
                          MyAssetImageWidget(
                            isSvg: true,
                            assetPath: MyIcons.walletIcon,
                            width: Dimensions.space24.w,
                            height: Dimensions.space24.w,
                          ),
                          spaceSide(Dimensions.space8),
                          Text(
                            MyStrings.yourWalletBalance.tr,
                            style: MyTextStyle.bodyTextStyle1.copyWith(
                              color: MyColor.getWhiteColor(),
                            ),
                          ),
                        ],
                      ),

                      // QR Code with PopupMenuButton
                      PopupMenuButton<String>(
                        surfaceTintColor: Colors.transparent,
                        icon: MyAssetImageWidget(
                          // color: MyColor.getPrimaryColor(),
                          isSvg: true,
                          assetPath: MyIcons.walletQrCodeIcon,
                          width: Dimensions.space40.w,
                          height: Dimensions.space40.w,
                        ),
                        position: PopupMenuPosition.under,
                        color: MyColor.getScreenBgColor(),
                        // shadowColor: MyColor.transparentColor,
                        onSelected: (value) {
                          if (value == "myQrCode") {
                            // Navigate to My QR Code Screen
                            Get.toNamed(RouteHelper.myQrCodeScreen);
                          } else if (value == "qrCodeLogin") {
                            // Navigate to Qr code Login Screen
                            Get.toNamed(RouteHelper.qrCodeLoginScreen);
                          }
                        },
                        itemBuilder: (context) => [
                          PopupMenuItem(
                            value: "myQrCode",
                            child: Row(
                              children: [
                                Icon(
                                  Icons.qr_code, // Replace with your desired icon
                                  color: MyColor.getHeaderTextColor(),
                                ),
                                spaceSide(
                                  Dimensions.space8,
                                ), // Spacing between icon and text
                                Text(
                                  MyStrings.myQrCode,
                                  style: MyTextStyle.bodyTextStyle1.copyWith(
                                    color: MyColor.getHeaderTextColor(),
                                  ),
                                ),
                              ],
                            ),
                          ),
                          if (SharedPreferenceService.isSupportQrCodeLogin()) ...[
                            PopupMenuItem(
                              value: "qrCodeLogin",
                              child: Row(
                                children: [
                                  MyAssetImageWidget(
                                    isSvg: true,
                                    assetPath: MyIcons.walletQrCodeIcon,
                                    width: Dimensions.space22.w,
                                    height: Dimensions.space22.w,
                                    color: MyColor.getHeaderTextColor(),
                                  ),
                                  spaceSide(
                                    Dimensions.space8,
                                  ), // Spacing between icon and text
                                  Text(
                                    MyStrings.qrCodeLogin,
                                    style: MyTextStyle.bodyTextStyle1.copyWith(
                                      color: MyColor.getHeaderTextColor(),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ],
                      ),
                    ],
                  ),
                ),
                spaceDown(Dimensions.space3),
                GetBuilder<HomeController>(
                  builder: (homeController) {
                    return InkWell(
                      onTap: () {
                        homeController.toggleBalanceVisibility();
                      },
                      child: Container(
                        height: Dimensions.space50,
                        padding: EdgeInsetsDirectional.symmetric(
                          horizontal: Dimensions.space12.w,
                        ),
                        child: FittedBox(
                          fit: BoxFit.scaleDown,
                          child: Row(
                            children: [
                              Text(
                                homeController.isBalanceVisible ? "${SharedPreferenceService.getCurrencySymbol()}${AppConverter.formatNumber(homeController.accountBalanceFormatted, forceShowPrecision: true)}" : "•••••••••",
                                overflow: TextOverflow.ellipsis,
                                style: MyTextStyle.balanceCardTextStyle.copyWith(
                                  color: MyColor.getWhiteColor(),
                                  fontSize: homeController.isBalanceVisible ? Dimensions.space35.sp : Dimensions.space50.sp,
                                ),
                                maxLines: 1,
                              ),
                              spaceSide(Dimensions.space10),
                              CustomAppCard(
                                height: Dimensions.space40,
                                width: Dimensions.space40,
                                showBorder: false,
                                radius: Dimensions.radiusProMax,
                                backgroundColor: MyColor.getWhiteColor().withValues(alpha: 0.15),
                                padding: EdgeInsets.all(Dimensions.space8),
                                child: FittedBox(
                                  fit: BoxFit.scaleDown,
                                  child: Icon(
                                    homeController.isBalanceVisible == true ? CupertinoIcons.eye : CupertinoIcons.eye_slash,
                                    color: MyColor.getWhiteColor(),
                                    size: Dimensions.space30,
                                  ),
                                ),
                              )
                            ],
                          ),
                        ),
                      ),
                    );
                  },
                ),
                spaceDown(Dimensions.space20),
                // Action Icons
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.spaceAround,
                  children: [
                    Flexible(
                      child: buildBalanceCardActionIcon(
                        iconImage: MyIcons.requestIcon,
                        titleText: MyStrings.withdraw,
                        onTap: () {
                          Get.toNamed(RouteHelper.withdrawMoneyScreen);
                        },
                      ),
                    ),
                    spaceSide(Dimensions.space10),
                    Flexible(
                      child: buildBalanceCardActionIcon(
                        iconImage: MyIcons.historyIcon,
                        titleText: MyStrings.history,
                        onTap: () {
                          Get.toNamed(RouteHelper.inboxScreen);
                        },
                      ),
                    ),
                  ],
                ),
              ],
            ),
          );
  }

  InkWell buildBalanceCardActionIcon({
    String iconImage = "",
    String titleText = "",
    VoidCallback? onTap,
  }) {
    return InkWell(
      onTap: onTap,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Skeleton.replace(
            replace: true,
            replacement: Bone.square(size: Dimensions.space40.h),
            child: CustomAppCard(
              showBorder: false,
              backgroundColor: MyColor.white.withValues(alpha: 0.15),
              padding: EdgeInsets.all(Dimensions.space10),
              height: Dimensions.space40.h,
              radius: Dimensions.space12,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  MyAssetImageWidget(
                    isSvg: true,
                    assetPath: iconImage,
                    color: MyColor.getWhiteColor(),
                    width: Dimensions.space24.w,
                    height: Dimensions.space24.w,
                  ),
                  spaceSide(Dimensions.space3),
                  Text(
                    titleText,
                    textAlign: TextAlign.center,
                    style: MyTextStyle.caption2Style.copyWith(
                      color: MyColor.getWhiteColor(),
                      fontWeight: FontWeight.w600,
                    ),
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}
