import 'package:dio/dio.dart' as dio;
import 'package:get/get.dart';
import 'package:ovopaymerchant/core/data/middleware/app_middleware.dart';
import 'package:ovopaymerchant/core/route/route.dart';

class MaintenanceMiddleware implements AppMiddleware {
  @override
  void handleResponse(response) {
    var responseData = response as dio.Response;

    if (responseData.data['remark'] == 'maintenance_mode') {
      if (Get.currentRoute != RouteHelper.maintenanceScreen) {
        Get.offAllNamed(RouteHelper.maintenanceScreen);
      }
    }
  }
}
