import 'package:ovopaymerchant/environment.dart';

class UrlContainer {
  static const String domainUrl = Environment.MAIN_API_URL;
  static const String baseUrl = '$domainUrl/api/';

  static const String socialLoginEndPoint = 'merchant/social-login';
  static const String dashBoardEndPoint = 'merchant/dashboard';

  static const String accountDisable = 'merchant/delete-account';

  static const String notificationEndPoint = 'merchant/push-notifications';
  static const String notificationSettingsEndPoint = 'merchant/notification/settings';

  static const String authenticationEndPoint = 'merchant/authentication';
  static const String logoutUrl = 'merchant/logout';
  static const String deleteAccountEndPoint = 'merchant/delete-account';

  static const String forgetPasswordEndPoint = 'merchant/password/mobile';
  static const String passwordVerifyEndPoint = 'merchant/password/verify-code';
  static const String resetPasswordEndPoint = 'merchant/password/reset';
  static const String verify2FAUrl = 'merchant/verify-g2fa';

  static const String otpVerify = 'merchant/otp-verify';
  static const String otpResend = 'merchant/otp-resend';

  static const String verifyEmailEndPoint = 'merchant/verify-email';
  static const String verifySmsEndPoint = 'merchant/verify-mobile';
  static const String resendVerifyCodeEndPoint = 'merchant/resend-verify/';
  static const String authorizationCodeEndPoint = 'merchant/authorization';

  static const String dashBoardUrl = 'merchant/dashboard';
  static const String transactionEndpoint = 'merchant/transactions';
  static const String statementsEndpoint = 'merchant/statements';

  static const String addWithdrawRequestUrl = 'merchant/withdraw-request';
  static const String withdrawMethodUrl = 'merchant/withdraw-method';
  static const String withdrawRequestConfirm = 'merchant/withdraw-request/confirm';
  static const String withdrawHistoryUrl = 'merchant/withdraw/history';

  static const String withdrawStoreUrl = 'merchant/withdraw/store/';
  static const String withdrawConfirmScreenUrl = 'merchant/withdraw/preview/';
  static const String withdrawSavedAccountStoreUrl = 'merchant/withdraw/account/save-data';
  static const String withdrawSavedAccountDeleteUrl = 'merchant/withdraw/account/delete';

  static const String kycFormUrl = 'merchant/kyc-form';
  static const String kycSubmitUrl = 'merchant/kyc-submit';
  static const String merchantVerificationFormUrl = 'merchant/verification-form';
  static const String merchantVerificationFormSubmitUrl = 'merchant/verification-submit';

  static const String generalSettingEndPoint = 'general-setting';
  static const String moduleSettingEndPoint = 'module-setting';
  static const String privacyPolicyEndPoint = 'policies';
  static const String faqEndPoint = 'faq';

  static const String getProfileEndPoint = 'merchant/user-info';
  static const String updateProfileEndPoint = 'merchant/profile-setting';
  static const String profileCompleteEndPoint = 'merchant/data-submit';

  static const String changePasswordEndPoint = 'merchant/change-password';
  static const String countryEndPoint = 'get-countries';

  static const String deviceTokenEndPoint = 'merchant/add-device-token';
  static const String languageUrl = 'language/';

  static const String twoFactor = 'merchant/twofactor';
  static const String twoFactorEnable = 'merchant/twofactor/enable';
  static const String twoFactorDisable = 'merchant/twofactor/disable';

  static const String communityGroupsEndPoint = 'merchant/community-groups';
  static const String pinValidate = 'merchant/pin/validate';

  static const String supportMethodsEndPoint = 'merchant/support/method';
  static const String supportListEndPoint = 'merchant/ticket';
  static const String storeSupportEndPoint = 'merchant/ticket/create';
  static const String supportViewEndPoint = 'merchant/ticket/view';
  static const String supportReplyEndPoint = 'merchant/ticket/reply';
  static const String supportCloseEndPoint = 'merchant/ticket/close';
  static const String supportDownloadEndPoint = 'merchant/ticket/download';
  static const String countryFlagImageLink = 'https://flagpedia.net/data/flags/h24/{countryCode}.webp';

  //Qr Code
  static const String myQrCodeEndPoint = 'merchant/qr-code';
  static const String myQrCodeDownloadEndPoint = 'merchant/qr-code/download';
  static const String myQrCodeRemoveEndPoint = 'merchant/qr-code/remove';
  static const String qrCodeScanEndPoint = 'merchant/qr-code/scan';
  static const String qrCodeLoginEndPoint = 'merchant/login-with/qr-code';

  static const String userExistEndPoint = 'merchant/check-user';
  static const String merchantExistEndPoint = 'merchant/merchant/exist';

  //Module
  ///Add Money
  static const String depositHistoryUrl = 'merchant/add-money/history';
  static const String depositMethodUrl = 'merchant/add-money/methods';
  static const String depositInsertUrl = 'merchant/add-money/insert';

  ///Add Money End

  ///Make Payment
  static const String makePaymentEndPoint = 'merchant/make-payment';
  static const String makePaymentHistoryEndPoint = 'merchant/make-payment/history';

  ///Make Payment End
  ///Cash IN
  static const String cashInEndPoint = 'merchant/cash-in';
  static const String cashInHistoryEndPoint = 'merchant/cash-in/history';
  //Cash IN End

  static const String supportImagePath = '$domainUrl/assets/support/';
  static const String languageImagePath = '$domainUrl/assets/images/language/';
  static const String withDrawImagePath = '$domainUrl/assets/images/withdraw_method/';
  static const String userImagePath = '$domainUrl/assets/images/user/profile/';
  static const String agentImagePath = '$domainUrl/assets/images/merchant/profile/';
  static const String merchantImagePath = '$domainUrl/assets/images/merchant/profile/';
  static const String maintenanceImagePath = '$domainUrl/assets/images/maintenance/';
}
