import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:ovopay/core/utils/text_style.dart';

class HeaderText extends StatelessWidget {
  final String text;
  final TextAlign? textAlign;
  final TextStyle? textStyle;

  const HeaderText({
    super.key,
    required this.text,
    this.textAlign,
    this.textStyle,
  });

  @override
  Widget build(BuildContext context) {
    return Text(
      text.tr,
      textAlign: textAlign,
      style: textStyle ?? MyTextStyle.sectionTitle,
    );
  }
}
