-- =====================================================
-- ==================== VERSION 1.2 ====================
-- =====================================================


CREATE TABLE `user_companies` (
  `id` bigint NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `company_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `customer_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `user_companies`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `user_companies`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

ALTER TABLE `withdrawals` ADD `submission_id` INT UNSIGNED NULL DEFAULT '0' AFTER `method_id`;

CREATE TABLE `withdraw_save_accounts` (
  `id` bigint NOT NULL,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `merchant_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `withdraw_method_id` bigint UNSIGNED NOT NULL DEFAULT '0',
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


ALTER TABLE `withdraw_save_accounts`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `withdraw_save_accounts`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

  ALTER TABLE `user_companies` CHANGE `customer_id` `unique_id` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL; 

ALTER TABLE `user_companies` DROP `reference_number`;

ALTER TABLE `utility_bills` ADD `unique_id` VARCHAR(255) NULL DEFAULT NULL AFTER `status`; 

ALTER TABLE `withdrawals` CHANGE `submission_id` `save_account_id` BIGINT UNSIGNED NULL DEFAULT '0'; 

ALTER TABLE `user_banks` DROP `user_data`;

ALTER TABLE `qr_codes` ADD `for_login` TINYINT NOT NULL COMMENT '0=no,1=yes' AFTER `unique_code`; 

ALTER TABLE `qr_codes` CHANGE `for_login` `for_login` TINYINT NOT NULL DEFAULT '1' COMMENT '0=no,1=yes'; 

ALTER TABLE `general_settings` ADD `pusher_config` TEXT NULL DEFAULT NULL AFTER `preloader_image`; 
ALTER TABLE `qr_codes` ADD `is_used` TINYINT(1) NOT NULL DEFAULT '0' AFTER `for_login`; 


CREATE TABLE `cron_jobs` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cron_schedule_id` int NOT NULL DEFAULT '0',
  `next_run` datetime DEFAULT NULL,
  `last_run` datetime DEFAULT NULL,
  `is_running` tinyint(1) NOT NULL DEFAULT '1',
  `is_default` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


INSERT INTO `cron_jobs` (`id`, `name`, `alias`, `action`, `url`, `cron_schedule_id`, `next_run`, `last_run`, `is_running`, `is_default`, `created_at`, `updated_at`) VALUES
(1, 'Reset Login Qr Code', 'reset_login_qr_code', '[\"App\\\\Http\\\\Controllers\\\\CronController\", \"resetLoginQrCode\"]', NULL, 1, '2024-06-11 10:13:06', '2024-06-10 10:13:06', 1, 1, NULL, '2024-06-09 22:13:06');

CREATE TABLE `cron_job_logs` (
  `id` bigint UNSIGNED NOT NULL,
  `cron_job_id` int UNSIGNED NOT NULL DEFAULT '0',
  `start_at` datetime DEFAULT NULL,
  `end_at` datetime DEFAULT NULL,
  `duration` int UNSIGNED NOT NULL DEFAULT '0',
  `error` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cron_schedules`
--

CREATE TABLE `cron_schedules` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `interval` int UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cron_schedules`
--

INSERT INTO `cron_schedules` (`id`, `name`, `interval`, `status`, `created_at`, `updated_at`) VALUES
(1, '5 Minute', 300, 1, '2025-01-19 04:54:50', '2025-01-19 04:55:32');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `cron_jobs`
--
ALTER TABLE `cron_jobs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cron_job_logs`
--
ALTER TABLE `cron_job_logs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cron_schedules`
--
ALTER TABLE `cron_schedules`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `cron_jobs`
--
ALTER TABLE `cron_jobs` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `cron_job_logs`
--
ALTER TABLE `cron_job_logs` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `cron_schedules`
--
ALTER TABLE `cron_schedules` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;


ALTER TABLE `general_settings` ADD `qrcode_login` TINYINT(1) NOT NULL DEFAULT '1' AFTER `pusher_config`; 

-- ====================================
-- ========= roles & permission =======
-- ====================================


CREATE TABLE `roles` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `guard_name`, `status`, `created_at`, `updated_at`) VALUES
(1, 'Super Admin', 'admin', 1, NULL, NULL),
(2, 'Admin', 'admin', 1, '2025-04-23 04:48:51', '2025-04-23 04:48:51');


--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;


CREATE TABLE `permissions` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `group_name`, `created_at`, `updated_at`) VALUES
(1, 'view send money', 'admin', 'send money', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(2, 'manage send money charge', 'admin', 'send money', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(3, 'view cash out', 'admin', 'cash out', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(4, 'manage cash out charge', 'admin', 'cash out', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(5, 'view cash in', 'admin', 'cash in', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(6, 'manage cash in charge', 'admin', 'cash in', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(7, 'view payment', 'admin', 'payment', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(8, 'manage payment charge', 'admin', 'payment', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(9, 'view bank transfer', 'admin', 'bank transfer', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(10, 'manage bank transfer bank', 'admin', 'bank transfer', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(11, 'manage bank transfer charge', 'admin', 'bank transfer', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(12, 'approve bank transfer', 'admin', 'bank transfer', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(13, 'reject bank transfer', 'admin', 'bank transfer', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(14, 'view microfinance', 'admin', 'microfinance', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(15, 'manage microfinance ngo', 'admin', 'microfinance', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(16, 'manage microfinance charge', 'admin', 'microfinance', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(17, 'approve microfinance', 'admin', 'microfinance', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(18, 'reject microfinance', 'admin', 'microfinance', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(19, 'view mobile recharge', 'admin', 'mobile recharge', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(20, 'manage mobile operator', 'admin', 'mobile recharge', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(21, 'manage mobile recharge charge', 'admin', 'mobile recharge', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(22, 'approve mobile recharge', 'admin', 'mobile recharge', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(23, 'reject mobile recharge', 'admin', 'mobile recharge', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(24, 'view airtime', 'admin', 'airtime', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(25, 'manage airtime operator', 'admin', 'airtime', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(26, 'view utility bill', 'admin', 'utility bill', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(27, 'manage utility bill charge', 'admin', 'utility bill', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(28, 'manage bill category', 'admin', 'utility bill', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(29, 'manage bill company', 'admin', 'utility bill', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(30, 'approve utility bill', 'admin', 'utility bill', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(31, 'reject utility bill', 'admin', 'utility bill', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(32, 'view education fee', 'admin', 'education fee', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(33, 'manage education fee charge', 'admin', 'education fee', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(34, 'manage institution', 'admin', 'education fee', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(35, 'manage institution category', 'admin', 'education fee', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(36, 'approve education fee', 'admin', 'education fee', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(37, 'reject education fee', 'admin', 'education fee', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(38, 'view donation', 'admin', 'donation', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(39, 'manage charity', 'admin', 'donation', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(40, 'view virtual card', 'admin', 'virtual card', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(41, 'configure virtual card provider', 'admin', 'virtual card', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(42, 'manage virtual card charge', 'admin', 'virtual card', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(43, 'view money requests', 'admin', 'request money', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(44, 'view users', 'admin', 'manage user', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(45, 'send user notification', 'admin', 'manage user', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(46, 'view user notifications', 'admin', 'manage user', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(47, 'update user balance', 'admin', 'manage user', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(48, 'ban user', 'admin', 'manage user', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(49, 'login as user', 'admin', 'manage user', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(50, 'update user', 'admin', 'manage user', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(51, 'view agents', 'admin', 'manage agent', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(52, 'send agent notification', 'admin', 'manage agent', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(53, 'view agent notifications', 'admin', 'manage agent', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(54, 'update agent balance', 'admin', 'manage agent', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(55, 'ban agent', 'admin', 'manage agent', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(56, 'login as agent', 'admin', 'manage agent', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(57, 'update agent', 'admin', 'manage agent', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(58, 'verify agent kyc', 'admin', 'manage agent', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(59, 'view merchants', 'admin', 'manage merchant', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(60, 'send merchant notification', 'admin', 'manage merchant', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(61, 'view merchant notifications', 'admin', 'manage merchant', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(62, 'update merchant balance', 'admin', 'manage merchant', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(63, 'ban merchant', 'admin', 'manage merchant', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(64, 'login as merchant', 'admin', 'manage merchant', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(65, 'update merchant', 'admin', 'manage merchant', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(66, 'verify merchant kyc', 'admin', 'manage merchant', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(67, 'manage banners', 'admin', 'promotion', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(68, 'manage offers', 'admin', 'promotion', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(69, 'view admin', 'admin', 'admin', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(70, 'add admin', 'admin', 'admin', '2025-04-21 18:47:48', '2025-04-21 18:47:48'),
(71, 'edit admin', 'admin', 'admin', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(72, 'view user add money', 'admin', 'user add money', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(73, 'approve user add money', 'admin', 'user add money', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(74, 'reject user add money', 'admin', 'user add money', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(75, 'view agent add money', 'admin', 'agent add money', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(76, 'approve agent add money', 'admin', 'agent add money', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(77, 'reject agent add money', 'admin', 'agent add money', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(78, 'view agent withdraw', 'admin', 'agent withdraw', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(79, 'approve agent withdraw', 'admin', 'agent withdraw', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(80, 'reject agent withdraw', 'admin', 'agent withdraw', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(81, 'view merchant withdraw', 'admin', 'merchant withdraw', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(82, 'approve merchant withdraw', 'admin', 'merchant withdraw', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(83, 'reject merchant withdraw', 'admin', 'merchant withdraw', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(84, 'view roles', 'admin', 'role', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(85, 'add role', 'admin', 'role', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(86, 'edit role', 'admin', 'role', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(87, 'assign permissions', 'admin', 'role', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(88, 'manage gateways', 'admin', 'gateway', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(89, 'manage withdraw methods', 'admin', 'gateway', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(90, 'update general settings', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(91, 'update brand settings', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(92, 'system configuration', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(93, 'notification settings', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(94, 'module settings', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(95, 'manage reloadly api', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(96, 'country settings', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(97, 'manage qr code', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(98, 'update maintenance mode', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(99, 'security settings', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(100, 'seo settings', 'admin', 'setting', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(101, 'view all transactions', 'admin', 'report', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(102, 'view user transactions', 'admin', 'report', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(103, 'view agent transactions', 'admin', 'report', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(104, 'view merchant transactions', 'admin', 'report', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(105, 'view login history', 'admin', 'report', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(106, 'view all notifications', 'admin', 'report', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(107, 'view user tickets', 'admin', 'support ticket', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(108, 'view agent tickets', 'admin', 'support ticket', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(109, 'view merchant tickets', 'admin', 'support ticket', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(110, 'answer tickets', 'admin', 'support ticket', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(111, 'close tickets', 'admin', 'support ticket', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(112, 'manage pages', 'admin', 'manage content', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(113, 'manage sections', 'admin', 'manage content', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(114, 'view dashboard', 'admin', 'other', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(115, 'manage extensions', 'admin', 'other', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(116, 'manage languages', 'admin', 'other', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(117, 'manage subscribers', 'admin', 'other', '2025-04-21 18:47:49', '2025-04-21 18:47:49'),
(120, 'manage cron job', 'admin', 'other', '2025-04-29 03:58:32', '2025-04-29 03:58:32'),
(121, 'view application info', 'admin', 'other', '2025-04-29 04:02:38', '2025-04-29 04:02:38');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;


--
-- Table structure for table `role_has_permissions`
--

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint UNSIGNED NOT NULL,
  `role_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1),
(15, 1),
(16, 1),
(17, 1),
(18, 1),
(19, 1),
(20, 1),
(21, 1),
(22, 1),
(23, 1),
(24, 1),
(25, 1),
(26, 1),
(27, 1),
(28, 1),
(29, 1),
(30, 1),
(31, 1),
(32, 1),
(33, 1),
(34, 1),
(35, 1),
(36, 1),
(37, 1),
(38, 1),
(39, 1),
(40, 1),
(41, 1),
(42, 1),
(43, 1),
(44, 1),
(45, 1),
(46, 1),
(47, 1),
(48, 1),
(49, 1),
(50, 1),
(51, 1),
(52, 1),
(53, 1),
(54, 1),
(55, 1),
(56, 1),
(57, 1),
(58, 1),
(59, 1),
(60, 1),
(61, 1),
(62, 1),
(63, 1),
(64, 1),
(65, 1),
(66, 1),
(67, 1),
(68, 1),
(69, 1),
(70, 1),
(71, 1),
(72, 1),
(73, 1),
(74, 1),
(75, 1),
(76, 1),
(77, 1),
(78, 1),
(79, 1),
(80, 1),
(81, 1),
(82, 1),
(83, 1),
(84, 1),
(85, 1),
(86, 1),
(87, 1),
(88, 1),
(89, 1),
(90, 1),
(91, 1),
(92, 1),
(93, 1),
(94, 1),
(95, 1),
(96, 1),
(97, 1),
(98, 1),
(99, 1),
(100, 1),
(101, 1),
(102, 1),
(103, 1),
(104, 1),
(105, 1),
(106, 1),
(107, 1),
(108, 1),
(109, 1),
(110, 1),
(111, 1),
(112, 1),
(113, 1),
(114, 1),
(115, 1),
(116, 1),
(117, 1),
(120, 1),
(121, 1),
(1, 2),
(2, 2),
(3, 2),
(4, 2),
(5, 2),
(6, 2),
(7, 2),
(8, 2),
(9, 2),
(10, 2),
(11, 2),
(12, 2),
(13, 2),
(14, 2),
(15, 2),
(16, 2),
(17, 2),
(18, 2),
(19, 2),
(20, 2),
(21, 2),
(22, 2),
(23, 2),
(24, 2),
(25, 2),
(26, 2),
(27, 2),
(28, 2),
(29, 2),
(30, 2),
(31, 2),
(32, 2),
(33, 2),
(34, 2),
(35, 2),
(36, 2),
(37, 2),
(38, 2),
(39, 2),
(40, 2),
(41, 2),
(42, 2),
(43, 2),
(44, 2),
(45, 2),
(46, 2),
(47, 2),
(48, 2),
(49, 2),
(50, 2),
(51, 2),
(52, 2),
(53, 2),
(54, 2),
(55, 2),
(56, 2),
(57, 2),
(58, 2),
(59, 2),
(60, 2),
(61, 2),
(62, 2),
(63, 2),
(64, 2),
(65, 2),
(66, 2),
(67, 2),
(68, 2),
(69, 2),
(70, 2),
(71, 2),
(72, 2),
(73, 2),
(74, 2),
(75, 2),
(76, 2),
(77, 2),
(78, 2),
(79, 2),
(80, 2),
(81, 2),
(82, 2),
(83, 2),
(84, 2),
(85, 2),
(86, 2),
(87, 2),
(88, 2),
(89, 2),
(90, 2),
(91, 2),
(92, 2),
(93, 2),
(94, 2),
(95, 2),
(96, 2),
(97, 2),
(98, 2),
(99, 2),
(100, 2),
(101, 2),
(102, 2),
(103, 2),
(104, 2),
(105, 2),
(106, 2),
(107, 2),
(108, 2),
(109, 2),
(110, 2),
(111, 2),
(112, 2),
(113, 2),
(114, 2),
(115, 2),
(116, 2),
(117, 2);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`role_id`),
  ADD KEY `role_has_permissions_role_id_foreign` (`role_id`);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;
COMMIT;



CREATE TABLE `model_has_permissions` (
  `permission_id` bigint UNSIGNED NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  ADD KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`);

ALTER TABLE `model_has_permissions`
  ADD CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE;
COMMIT;


CREATE TABLE `model_has_roles` (
  `role_id` bigint UNSIGNED NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `model_has_roles`
--

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES (1, 'App\\Models\\Admin', 1);

--
-- Indexes for dumped tables
--

--
-- Indexes for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  ADD KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;
COMMIT;



ALTER TABLE `qr_codes` CHANGE `for_login` `for_user_login` TINYINT NOT NULL DEFAULT '1' COMMENT '0=no,1=yes'; 

ALTER TABLE `qr_codes` ADD `for_agent_login` TINYINT(1) NOT NULL DEFAULT '1' AFTER `for_user_login`, ADD `for_merchant_login` TINYINT(1) NOT NULL DEFAULT '1' AFTER `for_agent_login`; 