DROP TABLE IF EXISTS `api_configurations`;

CREATE TABLE `api_providers` (
  `id` bigint UNSIGNED NOT NULL,
  `title` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `provider` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `config` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `token_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `access_token` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `token_expired_on` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `module` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `module_status` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `alias` text COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


ALTER TABLE `api_providers` ADD PRIMARY KEY (`id`);

ALTER TABLE `api_providers` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `companies` ADD `company_data` TEXT NULL DEFAULT NULL AFTER `status`;
ALTER TABLE `companies` ADD `minimum_amount` DECIMAL(28,8) NULL DEFAULT NULL AFTER `percent_charge`, ADD `maximum_amount` DECIMAL(28,8) NULL DEFAULT NULL AFTER `minimum_amount`;
UPDATE `forms` SET `act` ="utility_biller" WHERE `act` LIKE "%utility_%";
ALTER TABLE `user_companies` ADD `reference` VARCHAR(255) NULL DEFAULT NULL AFTER `user_data`;
ALTER TABLE `companies` CHANGE `fixed_charge` `fixed_charge` DECIMAL(28,8) NULL DEFAULT NULL, CHANGE `percent_charge` `percent_charge` DECIMAL(5,2) NULL DEFAULT NULL;
UPDATE `companies` SET `percent_charge` = NULL WHERE `companies`.`percent_charge` <= 0;
ALTER TABLE `utility_bills` ADD `reference` VARCHAR(255) NULL DEFAULT NULL AFTER `unique_id`, ADD `api_provider_id` INT NOT NULL DEFAULT '0' AFTER `reference`;
UPDATE `utility_bills` SET `status` = '9' WHERE `utility_bills`.`status` = 2;
ALTER TABLE `user_companies` DROP `reference`;
ALTER TABLE `utility_bills` ADD `api_provider_trx` VARCHAR(255) NULL DEFAULT NULL AFTER `api_provider_id`;

INSERT INTO `cron_schedules` (`id`, `name`, `interval`, `status`, `created_at`, `updated_at`) VALUES
(2, '1 Minute', 60, 1, '2025-07-28 04:21:42', '2025-07-28 04:21:42');

INSERT INTO `cron_jobs` (`id`, `name`, `alias`, `action`, `url`, `cron_schedule_id`, `next_run`, `last_run`, `is_running`, `is_default`, `created_at`, `updated_at`) VALUES
(2, 'Update Automatic Utility Bill Payment', 'update_automatic_utility_bill_payment', '[\"App\\\\Http\\\\Controllers\\\\CronController\", \"updateAutomaticBillPayment\"]', NULL, 2, '2024-06-11 10:13:00', '2024-06-10 10:13:06', 1, 1, NULL, '2025-07-28 04:22:31');

ALTER TABLE `api_providers` ADD `instruction` TEXT NULL DEFAULT NULL AFTER `module_status`; 


ALTER TABLE `api_providers` ADD `description` TEXT NULL DEFAULT NULL AFTER `instruction`; 

ALTER TABLE `api_providers` DROP `token_type`, DROP `token_expired_on`; 
ALTER TABLE `api_providers` DROP `module_status`;



INSERT INTO `api_providers` (`id`, `title`, `provider`, `config`, `status`, `access_token`, `module`, `instruction`, `description`, `created_at`, `updated_at`, `alias`) VALUES
(2, 'Reloadly API', 'reloadly_api', '[{\"name\":\"client_id\",\"title\":\"Client ID\",\"value\":\"-----------\",\"is_copy\":false,\"is_required\":true},{\"name\":\"client_secret\",\"title\":\"Client Secret\",\"value\":\"------------\",\"is_copy\":false,\"is_required\":true},{\"name\":\"environment\",\"title\":\"Environment\",\"value\":\"sandbox\",\"is_copy\":false,\"is_required\":true}]', 1, '{\"utility_token\":{\"name\":\"utility_token\",\"value\":\"-----------------------\",\"expired_at\":\"2025-07-30T13:45:12.202550Z\",\"token_type\":\"Bearer\"},\"airtime_token\":{\"name\":\"airtime_token\",\"value\":\"--------------",\"expired_at\":\"2025-07-30T13:40:22.811598Z\",\"token_type\":\"Bearer\"}}', '[\"utility_bill\",\"airtime\"]', ' \n                        <h5>How to Get Reloadly API Credentials\'</h5>\n                        <ul class=\"list-group list-group-flush list-unstyled\">\n                            <li class=\"list-group-item ps-0\">\n                                <strong>Sign Up or Log In\':</strong>\n                                Visit the <a href=\"https://www.reloadly.com/\" target=\"_blank\">\n                                    Reloadly Dashboard <i class=\"fa fa-external-link\"></i>\n                                </a> and sign up or log in to your account.\n                            </li>\n                            <li class=\"list-group-item ps-0\">\n                                <strong>Access API Keys:</strong>\n                                From the left sidebar, navigate to <strong>Developers</strong> &gt; <strong>API\n                                    Keys</strong>.\n                            </li>\n                            <li class=\"list-group-item ps-0\">\n                                <strong>Get Your Credentials:</strong>\n                                You will find your <strong>Client ID</strong> and <strong>Client Secret</strong> under both\n                                <code>Sandbox</code> and <code>Live</code> environments. Copy the credentials based on your\n                                integration needs.\n                            </li>\n                            <li class=\"list-group-item ps-0\">\n                                <strong>Select Environment:</strong>\n                                Choose <code>Sandbox</code> for testing purposes or <code>Live</code> for production usage.\n                            </li>\n                            <li class=\"list-group-item ps-0\">\n                                <strong>Submit:</strong>\n                                Paste the <strong>Client ID</strong> and <strong>Client Secret</strong> into the appropriate\n                                fields in your system\'s <strong>Credentials</strong> section and click\n                                <strong>Submit</strong>.\n                            </li>\n                        </ul>', 'Reloadly is a leading API provider for global airtime top-ups, utility bill payments, and more.', '2025-01-08 00:14:24', '2025-07-29 07:45:12', 'Reloadly');

UPDATE `api_providers` SET `alias` = 'ReloadLy' WHERE `api_providers`.`id` = 2;




ALTER TABLE `api_providers` CHANGE `module` `module` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL AFTER `access_token`, CHANGE `instruction` `instruction` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL AFTER `module`, CHANGE `alias` `alias` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL AFTER `instruction`, CHANGE `description` `description` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL AFTER `alias`, CHANGE `updated_at` `updated_at` TIMESTAMP NULL DEFAULT NULL AFTER `description`; 

ALTER TABLE `api_providers` CHANGE `status` `status` TEXT NULL DEFAULT NULL; 
UPDATE `api_providers` SET `status` = '{\"utility_bill\":1,\"airtime\":1}' WHERE `api_providers`.`id` = 2; 


ALTER TABLE `utility_bills` ADD `cron_ordering` BIGINT NOT NULL DEFAULT '0' AFTER `api_provider_trx`;
