INSERT INTO `cron_jobs` (`name`, `alias`, `action`, `url`, `cron_schedule_id`, `next_run`, `last_run`, `is_running`, `is_default`, `created_at`, `updated_at`) VALUES ('Update Airtime Operator', 'update_airtime_operator', '[\"App\\\\Http\\\\Controllers\\\\CronController\", \"updateOperator\"]', NULL, '1', '2024-06-11 10:13:00', '2024-06-10 10:13:06', '1', '1', NULL, '2025-07-28 17:22:31');

ALTER TABLE `operators` ADD `cron_ordering` BIGINT NOT NULL DEFAULT '0' AFTER `reloadly_status`;

ALTER TABLE `topups` CHANGE `mobile_number` `mobile_number` TEXT NULL DEFAULT NULL;

CREATE TABLE `gift_card_categories` (
  `id` bigint UNSIGNED NOT NULL,
  `unique_id` int UNSIGNED NOT NULL,
  `name` varchar(40) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `gift_card_categories`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `gift_card_categories`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

CREATE TABLE `gift_cards` (
  `id` bigint NOT NULL,
  `product_id` int NOT NULL,
  `product_name` varchar(255) DEFAULT NULL,
  `is_global` tinyint(1) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `supports_pre_order` tinyint(1) DEFAULT NULL,
  `sender_fee` decimal(28,8) DEFAULT NULL,
  `sender_fee_percentage` decimal(5,2) DEFAULT NULL,
  `discount_percentage` decimal(5,2) DEFAULT NULL,
  `denomination_type` varchar(20) DEFAULT NULL,
  `recipient_currency_code` varchar(10) DEFAULT NULL,
  `min_recipient_denomination` decimal(28,8) DEFAULT NULL,
  `max_recipient_denomination` decimal(28,8) DEFAULT NULL,
  `sender_currency_code` varchar(10) DEFAULT NULL,
  `min_sender_denomination` decimal(28,8) DEFAULT NULL,
  `max_sender_denomination` decimal(28,8) DEFAULT NULL,
  `fixed_recipient_denominations` text,
  `fixed_sender_denominations` text,
  `fixed_recipient_to_sender_map` text,
  `metadata` text,
  `logo_urls` text,
  `brand_id` int DEFAULT NULL,
  `brand_name` varchar(100) DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `category_name` varchar(100) DEFAULT NULL,
  `country_iso_name` varchar(10) DEFAULT NULL,
  `country_name` varchar(100) DEFAULT NULL,
  `country_flag_url` varchar(255) DEFAULT NULL,
  `redeem_instruction_concise` text,
  `redeem_instruction_verbose` text,
  `user_id_required` tinyint(1) DEFAULT NULL,
  `recipient_to_sender_exchange_rate` decimal(28,8) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `gift_cards`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `gift_cards`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

INSERT INTO `module_settings` (`user_type`, `title`, `slug`, `description_disabled`, `description_enabled`, `icon`, `status`, `created_at`, `updated_at`) VALUES ('USER', 'Gift Card', 'gift_card', 'Disable this feature to restrict users from performing gift card.', 'Enable this feature to allow users to performing gift card.', 'las la-gift', '1', '2021-06-15 05:45:01', '2025-06-24 20:06:17');

CREATE TABLE `gift_card_purchases` (
  `id` bigint UNSIGNED NOT NULL,
  `user_id` int UNSIGNED NOT NULL DEFAULT '0',
  `product_id` int UNSIGNED NOT NULL DEFAULT '0',
  `amount` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `charge` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `quantity` int NOT NULL DEFAULT '0',
  `total` decimal(28,8) NOT NULL DEFAULT '0.00000000',
  `trx` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `recipient_email` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `api_provider_id` int NOT NULL DEFAULT '0',
  `api_provider_trx` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cron_ordering` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `gift_card_purchases`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `gift_card_purchases`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `gift_card_purchases` ADD `discount` DECIMAL(28,8) NOT NULL DEFAULT '0' AFTER `charge`;

INSERT INTO `cron_jobs` (`name`, `alias`, `action`, `url`, `cron_schedule_id`, `next_run`, `last_run`, `is_running`, `is_default`, `created_at`, `updated_at`) VALUES ('Update Gift Card Purchase', 'update_gift_card_purchase', '[\"App\\\\Http\\\\Controllers\\\\CronController\", \"updateGiftCardPurchase\"]', NULL, '1', '2024-06-11 10:13:00', '2024-06-10 10:13:06', '1', '1', NULL, '2025-08-04 00:50:22');

INSERT INTO `notification_templates` (`act`, `name`, `subject`, `push_title`, `email_body`, `sms_body`, `push_body`, `shortcodes`, `email_status`, `email_sent_from_name`, `email_sent_from_address`, `sms_status`, `sms_sent_from`, `push_status`, `created_at`, `updated_at`) VALUES ('GIFT_CARD_APPROVE', 'Gift  Card Approved', 'Gift Card Approved', 'Gift Card Approved', '<p>Dear<b> {{user}}</b>,</p><p>We are pleased to inform you that your gift card purchase has been successfully approved for <strong>{{utility}}</strong>.</p><p>Here are the details of the transaction:</p><ul><li><strong>Utility Name:</strong> {{product}}</li><li><strong>Payment Status:</strong> Paid</li><li><strong>Amount:</strong> {{amount}}</li><li><strong>Charge:</strong> {{charge}}</li></ul><p>Thank you for settling your <strong>{{product}}</strong> bill. If you have any questions or need further assistance, feel free to contact us.</p><p>Best regards,<br>{{site_name}}</p>', 'We are pleased to inform you that your gift card purchase has been successfully approved for {{product}}.', 'Your gift card purchase has been approved', '{\"user\":\"User name\",\"amount\":\"Gift card amount\", \"charge\":\"Gift card purchase charge\",\"product\":\"Gift Card name\",\"trx\":\"Transaction number\",\"time\":\"Gift Card Purchase time\",\"post_balance\":\"Remaining balance\"}', '1', NULL, NULL, '0', NULL, '1', NULL, '2025-03-16 06:45:56');
INSERT INTO `notification_templates` (`act`, `name`, `subject`, `push_title`, `email_body`, `sms_body`, `push_body`, `shortcodes`, `email_status`, `email_sent_from_name`, `email_sent_from_address`, `sms_status`, `sms_sent_from`, `push_status`, `created_at`, `updated_at`) VALUES ('GIFT_CARD_REJECT', 'Gift Card Rejected', 'Gift Card Purchase Rejected', 'Gift Card Purchase Rejected', '<p>Dear {<b>{{user}}</b>,</p><p>We regret to inform you that your gift card purchase has been rejected for <strong>{{utility}}</strong>.</p><p>Here are the details of the transaction:</p><ul><li><strong>Gift Card Name:</strong> {{product}}</li><li><strong>Payment Status:</strong> Rejected</li><li><span style=\"font-weight: bolder;\">Reason:</span>&nbsp;{{reason}}<br></li><li><strong>Amount:</strong> {{amount}}</li><li><strong>Charge:</strong> {{charge}}</li></ul><p>Please review your payment details or contact our support team for further assistance. We apologize for any inconvenience caused and are here to help resolve the issue.</p><p>Best regards,<br>{{site_name}}</p>', 'We regret to inform you that your gift card purchase has been rejected for {{product}}.', 'Your gift card purchase has been rejected.', '{\"user\":\"User name\",\"amount\":\"Gift card amount\", \"charge\":\"Gift card charge\",\"product\":\"Gift card name\",\"trx\":\"Transaction number\",\"reason\":\"Reason of Rejection\",\"time\":\"Gift card purchase time\",\"post_balance\":\"Remaining balance\"}', '1', NULL, NULL, '0', NULL, '1', NULL, '2025-03-16 06:45:36');
INSERT INTO `notification_templates` (`act`, `name`, `subject`, `push_title`, `email_body`, `sms_body`, `push_body`, `shortcodes`, `email_status`, `email_sent_from_name`, `email_sent_from_address`, `sms_status`, `sms_sent_from`, `push_status`, `created_at`, `updated_at`) VALUES ('GIFT_CARD_PURCHASE_COMPLETED', 'Gift Card Purchase Completed', 'Gift Card Purchase Completed Successfully', 'Gift Card Purchase Completed Successfully', '<p>Dear <b>{{user}}</b>,</p><p>We are happy to inform you that your gift card purchase has been approved.', 'We are happy to inform you that your gift card purchase has been approved.', 'We are happy to inform you that your gift card purchase has been approved.', '{\"user\":\"User name\",\"amount\":\"Gift card amount\", \"charge\":\"Gift card charge\",\"product\":\"Gift card name\",\"trx\":\"Transaction number\",\"reason\":\"Reason of Rejection\",\"time\":\"Gift card purchase time\",\"post_balance\":\"Remaining balance\",\"quantity\":\"Gift Card Quantity\",\"email\":\"Receipient Email\"}', '1', NULL, NULL, '0', NULL, '1', NULL, '2025-03-16 06:45:36');


INSERT INTO `permissions` (`id`, `name`, `guard_name`, `group_name`, `created_at`, `updated_at`) VALUES
(124, 'view gift card purchases', 'admin', 'gift card', '2025-10-13 07:35:09', '2025-10-13 07:35:09'),
(123, 'manage gift card', 'admin', 'gift card', '2025-10-13 07:35:09', '2025-10-13 07:35:09'),
(122, 'manage gift card category', 'admin', 'gift card', '2025-10-13 07:35:09', '2025-10-13 07:35:09');

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(124, 1),
(123, 1),
(122, 1);

UPDATE api_providers
SET module = JSON_ARRAY_APPEND(module, '$', 'gift_card')
WHERE JSON_CONTAINS(module, '"gift_card"') = 0;


UPDATE api_providers
SET status = JSON_SET(status, '$.gift_card', '0')
WHERE JSON_EXTRACT(status, '$.gift_card') IS NULL;


UPDATE api_providers
SET access_token = JSON_SET(
    access_token,
    '$.gift_card_token',
    JSON_OBJECT(
        'name', 'gift_card_token',
        'value', NULL,
        'expired_at', NULL,
        'token_type', 'Bearer'
    )
)
WHERE JSON_EXTRACT(access_token, '$.gift_card_token') IS NULL;



 ALTER TABLE `countries` ADD `is_airtime` TINYINT(1) NOT NULL DEFAULT '0' AFTER `status`; 
 UPDATE `countries` SET `is_airtime` = '1';
 
ALTER TABLE `countries` ADD `is_gift_card` TINYINT(1) NOT NULL DEFAULT '0' AFTER `is_airtime`;

ALTER TABLE `gift_cards`
  DROP `country_iso_name`,
  DROP `country_name`,
  DROP `country_flag_url`; 

ALTER TABLE `gift_cards` ADD `country_id` INT UNSIGNED NOT NULL DEFAULT '0' AFTER `product_id`; 



UPDATE `operators`
SET `fx` = JSON_EXTRACT(fx, '$.rate');

ALTER TABLE `operators` CHANGE `fx` `rate` DECIMAL(28,8) NULL DEFAULT '0'; 

ALTER TABLE `gift_card_purchases` ADD `rate` DECIMAL(28,8) NOT NULL DEFAULT '1' AFTER `discount`, ADD `unit_price` DECIMAL(28,8) NOT NULL DEFAULT '0' AFTER `rate`, ADD `sub_total` DECIMAL(28,8) NOT NULL DEFAULT '0' AFTER `unit_price`;

UPDATE `notification_templates` SET `email_body` = '<p>We’re pleased to inform you that your gift card purchase has been <strong>successfully completed</strong>.</p>\r\n\r\n<p>Here are the details of your transaction:</p>\r\n\r\n<ul>\r\n <li><strong>Gift Card Name:</strong> {{product}}</li>\r\n <li><strong>Quantity:</strong> {{quantity}}</li>\r\n <li><strong>Gift Card Amount:</strong> {{amount}} {{site_currency}}</li>\r\n <li><strong>Charge:</strong> {{charge}} {{site_currency}}</li>\r\n <li><strong>Transaction Number:</strong> {{trx}}</li>\r\n <li><strong>Purchase Time:</strong> {{time}}</li>\r\n <li><strong>Recipient Email:</strong> {{email}}</li>\r\n <li><strong>Remaining Balance:</strong> {{post_balance}} {{site_currency}}</li>\r\n</ul>\r\n\r\n<p>Your gift card(s) have been processed successfully and are now available for use or delivery to the recipient.</p>\r\n\r\n<p>Thank you for choosing our service. We appreciate your trust and look forward to serving you again!</p>\r\n\r\n<p>Best regards,<br>{{site_name}}</p>', `created_at` = NULL WHERE `notification_templates`.`act` = 'GIFT_CARD_PURCHASE_COMPLETED';

INSERT INTO `cron_jobs` (`name`, `alias`, `action`, `url`, `cron_schedule_id`, `next_run`, `last_run`, `is_running`, `is_default`, `created_at`, `updated_at`) VALUES ('Update All Gift Card Data', 'update_all_gift_card_data', '[\"App\\\\Http\\\\Controllers\\\\CronController\", \"updateAllGiftCardsData\"]', NULL, '1', '2024-06-11 10:13:00', '2024-06-10 10:13:06', '1', '1', NULL, '2025-08-04 00:50:22');

ALTER TABLE `gift_cards` ADD `cron_ordering` BIGINT NOT NULL DEFAULT '0' AFTER `recipient_to_sender_exchange_rate`;

UPDATE `module_settings` SET `title` = 'Mobile Recharge' WHERE `module_settings`.`slug` = 'air_time';

DELETE FROM `module_settings` WHERE `module_settings`.`slug` = 'mobile_recharge';

UPDATE `module_settings` SET `slug` = 'mobile_recharge' WHERE `module_settings`.`title` = 'Mobile Recharge';
ALTER TABLE `utility_bills` ADD `token` TEXT NULL DEFAULT NULL AFTER `cron_ordering`;

ALTER TABLE `companies` DROP `form_id`; 
ALTER TABLE `companies` ADD `rate` DECIMAL(28,8) NOT NULL DEFAULT '0' AFTER `status`;
ALTER TABLE `countries` ADD `is_utility_bill` TINYINT NOT NULL DEFAULT '0' AFTER `is_gift_card`; 

ALTER TABLE `companies` ADD `country_id` INT UNSIGNED NOT NULL DEFAULT '0' AFTER `category_id`; 
ALTER TABLE `companies` ADD `service_type` VARCHAR(255) NULL DEFAULT NULL AFTER `name`; 
ALTER TABLE `user_companies` DROP `user_data`;
ALTER TABLE `companies` ADD `company_id` TEXT NULL DEFAULT NULL AFTER `rate`; 
ALTER TABLE `companies` ADD `currency_code` TEXT NULL DEFAULT NULL AFTER `name`; 
ALTER TABLE `utility_bills` ADD `rate` DECIMAL(28,8) NOT NULL DEFAULT '1' AFTER `token`; 
ALTER TABLE `utility_bills` DROP `user_data`;
ALTER TABLE `companies` ADD `denomination_type` TEXT NULL DEFAULT NULL AFTER `company_id`, ADD `fixed_amounts` TEXT NULL DEFAULT NULL AFTER `denomination_type`; 
        

ALTER TABLE `countries` CHANGE `is_utility_bill` `is_utility_bill` TINYINT NOT NULL DEFAULT '0'; 

-- Add maximum_amount column if not exists
SET @stmt = (
  SELECT IF(
    COUNT(*) = 0,
    'ALTER TABLE `companies` ADD COLUMN `maximum_amount` DECIMAL(28,8) NOT NULL DEFAULT 0 AFTER `service_type`;',
    'SELECT "Column maximum_amount already exists";'
  )
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE()
  AND TABLE_NAME = 'companies'
  AND COLUMN_NAME = 'maximum_amount'
);
PREPARE stmt FROM @stmt;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add minimum_amount column if not exists
SET @stmt = (
  SELECT IF(
    COUNT(*) = 0,
    'ALTER TABLE `companies` ADD COLUMN `minimum_amount` DECIMAL(28,8) NOT NULL DEFAULT 0 AFTER `maximum_amount`;',
    'SELECT "Column minimum_amount already exists";'
  )
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE()
  AND TABLE_NAME = 'companies'
  AND COLUMN_NAME = 'minimum_amount'
);
PREPARE stmt FROM @stmt;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;




