@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-12">
            <x-admin.ui.card>
                <x-admin.ui.card.body>
                    <form action="" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="form-group col-sm-6">
                                <label>@lang('Minimum Load Amount') </label>
                                <span>
                                    <i class="las la-info-circle" data-bs-toggle="tooltip" title="@lang('Specify the minimum amount that can be loaded onto the virtual card.')"></i>
                                </span>
                                <div class="input-group input--group">
                                    <input class="form-control" type="number" name="min_load_amount" required
                                        value="{{ getAmount(@$charge->min_limit) }}">
                                    <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                </div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label>@lang('Maximum Load Amount')</label>
                                <span>
                                    <i class="las la-info-circle" data-bs-toggle="tooltip" title="@lang('Specify the maximum amount that can be loaded onto the virtual card.')"></i>
                                </span>
                                <div class="input-group input--group">
                                    <input class="form-control" type="number" name="max_load_amount" required
                                        value="{{ getAmount(@$charge->max_limit) }}">
                                    <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                </div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label>@lang('Fixed Charge')</label>
                                <span>
                                    <i class="las la-info-circle" data-bs-toggle="tooltip" title="@lang('Enter the fixed charge for loading funds onto the virtual card.')"></i>
                                </span>
                                <div class="input-group input--group">
                                    <input class="form-control" type="number" name="fixed_charge" required
                                        value="{{ getAmount(@$charge->fixed_charge) }}">
                                    <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                </div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label>@lang('Percent Charge')</label>
                                <span><i class="las la-info-circle" data-bs-toggle="tooltip"
                                        title="@lang('Enter the percentage-based charge for loading funds onto the virtual card.')"></i></span>
                                <div class="input-group input--group">
                                    <input class="form-control" type="number" name="percent_charge" required
                                        value="{{ getAmount(@$charge->percent_charge) }}">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                            <div class="form-group col-lg-12">
                                <label>@lang('Maximum Card Generation')</label>
                                <span><i class="las la-info-circle" data-bs-toggle="tooltip"
                                        title="@lang('Enter the maximum number of cards generated by a single user.  Use -1 for the no limit.')"></i></span>
                                <input class="form-control" type="number" name="maximum_card_generate" required
                                    value="{{ getAmount(@$charge->maximum_card_generate) }}">
                            </div>
                            <div class="col-12">
                                <x-admin.ui.btn.submit />
                            </div>
                        </div>
                    </form>
                </x-admin.ui.card.body>
            </x-admin.ui.card>
        </div>
    </div>
@endsection