@extends($activeTemplate . 'layouts.agent')
@section('content')
    <div class="row justify-content-center justify-content-xl-start">
        <div class="col-xxl-6 col-xl-8 col-lg-8">
            <div class="card custom--card">
                <div class="card-body">
                    <form method="POST">
                        @csrf
                        <ul class="list-group list-group-flush mb-4">
                            <li class="list-group-item d-flex gap-2 flex-wrap justify-content-between ps-0">
                                <span class="d-flex gap-2 flex-wrap pe-5 pe-md-0">
                                    <span class="section-bg notification-icon d-none d-md-block text-center">
                                        <i class="la la-envelope"></i>
                                    </span>
                                    <span>
                                        <span class="fs-18">
                                            @lang('Email Notification')
                                        </span>
                                        <span class="d-block fs-14">@lang('Receive important updates via email')</span>
                                    </span>
                                </span>
                                <span>
                                    <div class="form-check form-switch form--switch pl-0 form-switch-success ps-0">
                                        <input class="form-check-input" type="checkbox" role="switch" name="en"
                                            @checked($agent->en)>
                                    </div>
                                </span>
                            </li>
                            <li class="list-group-item d-flex gap-2 flex-wrap justify-content-between ps-0">
                                <span class="d-flex gap-2 flex-wrap pe-5 pe-md-0">
                                    <span class="section-bg notification-icon d-none d-md-block text-center">
                                        <i class="la la-mobile-phone"></i>
                                    </span>
                                    <span>
                                        <span class="fs-18">
                                            @lang('SMS Notification')
                                        </span>
                                        <span class="d-block fs-14">@lang('Get instant alerts via SMS')</span>
                                    </span>
                                </span>
                                <span>
                                    <div class="form-check form-switch form--switch pl-0 form-switch-success ps-0">
                                        <input class="form-check-input" type="checkbox" role="switch" name="sn"
                                            @checked($agent->sn)>
                                    </div>
                                </span>
                            </li>
                            <li class="list-group-item d-flex gap-2 flex-wrap justify-content-between ps-0">
                                <span class="d-flex gap-2 flex-wrap pe-5 pe-md-0">
                                    <span class="section-bg notification-icon d-none d-md-block text-center">
                                        <i class="la la-bell"></i>
                                    </span>
                                    <span>
                                        <span class="fs-18">
                                            @lang('Push Notification')
                                        </span>
                                        <span class="d-block fs-14">@lang('Stay updated with real-time push notifications')</span>
                                    </span>
                                </span>
                                <span>
                                    <div class="form-check form-switch form--switch pl-0 form-switch-success ps-0">
                                        <input class="form-check-input" type="checkbox" role="switch" name="pn"
                                            @checked($agent->pn)>
                                    </div>
                                </span>
                            </li>
                            <li class="list-group-item d-flex gap-2 flex-wrap justify-content-between ps-0">
                                <span class="d-flex gap-2 flex-wrap pe-5 pe-md-0">
                                    <span class="section-bg notification-icon d-none d-md-block text-center">
                                        <i class="la la-bell-slash-o"></i>
                                    </span>
                                    <span>
                                        <span class="fs-18">
                                            @lang('Allow Promotional Notification')
                                        </span>
                                        <span class="d-block fs-14">@lang('Receive exclusive deals and offers')</span>
                                    </span>
                                </span>
                                <span>
                                    <div class="form-check form-switch form--switch pl-0 form-switch-success ps-0">
                                        <input class="form-check-input" type="checkbox" role="switch"
                                            name="is_allow_promotional_notify" @checked($agent->is_allow_promotional_notify)>
                                    </div>
                                </span>
                            </li>
                        </ul>

                        <button class="btn btn--base btn--md" type="submit">
                            <i class="fa fa-paper-plane"></i> @lang('Update Notification Setting')
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('style')
    <style>
        /*  Custom Switch Design */
        .form--switch .form-check-input {
            border-radius: 3px;
            background-image: none;
            position: relative;
            box-shadow: none;
            border: 0;
            background-color: hsl(var(--black)/0.1) !important;
            padding: 10px !important;
            margin-left: 0;
            margin-bottom: 5px;
            border-radius: 40px;
            width: 45px;
            height: 20px;
            cursor: pointer;
        }

        .form--switch .form-check-input:focus {
            border-radius: 40px;
            background-image: none;
            position: relative;
            box-shadow: none;
            border: 0;
        }

        .form--switch .form-check-input::before {
            position: absolute;
            content: "";
            width: 15px;
            height: 15px;
            background-color: #fff;
            top: 50%;
            transform: translateY(-50%);
            border-radius: 2px;
            left: 3px;
            border-radius: 50%;
            transition: 0.2s linear;
        }

        .form--switch .form-check-input:checked {
            background-color: hsl(var(--primary)) !important;
        }

        .form--switch .form-check-input:checked::before {
            left: calc(100% - 18px);
            background-color: #fff !important;
        }

        .form--switch .form-check-input:checked[type=checkbox] {
            background-image: none;
        }

        .form--switch .form-check-label {
            width: calc(100% - 14px);
            padding-left: 5px;
            cursor: pointer;
        }

        .form--switch.switch--lg .form-check-input {
            width: 70px;
            height: 38px;
        }

        .form--switch.switch--lg .form-check-input::before {
            width: 28px;
            height: 28px;
        }

        .form--switch.switch--lg .form-check-input:checked {
            background-color: hsl(var(--success)) !important;
        }

        .form--switch.switch--lg .form-check-input:checked::before {
            left: calc(100% - 33px);
        }

        .form-switch-success.form--switch .form-check-input:checked {
            background-color: hsl(var(--success)) !important;
        }
    </style>
@endpush
