@extends($activeTemplate . 'layouts.merchant')
@section('content')
    @php
        $kyc = getContent('kyc.content', true);
    @endphp
    <div class="notice"></div>
    <div class="row justify-content-center gy-4">
        @if (auth('merchant')->user()->kv == Status::KYC_UNVERIFIED && auth('merchant')->user()->kyc_rejection_reason)
            <div class="col-12">
                <div class="alert alert--danger" role="alert">
                    <div class="alert__icon">
                        <i class="fa fa-times"></i>
                    </div>
                    <div class="alert__content">
                        <h6 class="alert__title">@lang('KYC Verification Rejected')</h6>
                        <p class="alert__desc">
                            {{ __(@$kyc->data_values->reject) }}
                            <a href="{{ route('merchant.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a>,
                            <button type="button" class="text--danger" href="{{ route('merchant.kyc.form') }}"
                                data-bs-toggle="modal" data-bs-target="#kycRejectionReason">@lang('Show Reject Reason')</button>.
                        </p>
                    </div>
                </div>
            </div>
        @elseif(auth('merchant')->user()->kv == Status::KYC_UNVERIFIED)
            <div class="col-12">
                <div class="alert alert--info" role="alert">
                    <div class="alert__icon">
                        <i class="fa fa-info"></i>
                    </div>
                    <div class="alert__content">
                        <h6 class="alert__title">@lang('KYC Verification Required')</h6>
                        <p class="alert__desc">
                            {{ __(@$kyc->data_values->required) }} <a
                                href="{{ route('merchant.kyc.form') }}">@lang('Click Here to Submit Documents')</a>
                        </p>
                    </div>
                </div>
            </div>
        @elseif(auth('merchant')->user()->kv == Status::KYC_PENDING)
            <div class="col-12">
                <div class="alert alert--warning" role="alert">
                    <div class="alert__icon">
                        <i class="fa fa-info"></i>
                    </div>
                    <div class="alert__content">
                        <h6 class="alert__title">@lang('KYC Verification Pending')</h6>
                        <p class="alert__desc">
                            {{ __(@$kyc->data_values->pending) }}
                            <a href="{{ route('merchant.kyc.data') }}">@lang('See KYC Data')
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        @endif
        <div class="col-lg-12">
            <div class="card custom--card mb-4">
                <div class="card-body">
                    <div class="mywallet">
                        <div class="mywallet-left">
                            <div class="mywallet-title">
                                <span class="icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M18.7077 5.14068C18.7931 5.4585 18.8239 5.80758 18.835 6.21961C18.981 6.2325 19.1214 6.24776 19.2563 6.26586C20.1631 6.38748 20.9639 6.65265 21.6051 7.29235C22.2463 7.93206 22.512 8.73099 22.6339 9.63562C22.7501 10.4973 22.75 11.586 22.75 12.9063V14.9938C22.75 16.3141 22.7501 17.4028 22.6339 18.2645C22.512 19.1691 22.2463 19.968 21.6051 20.6077C20.9639 21.2474 20.1631 21.5126 19.2563 21.6342C18.3927 21.7501 17.3014 21.75 15.978 21.75H9.97398C8.19196 21.75 6.75559 21.75 5.6259 21.5985C4.45303 21.4412 3.4655 21.1046 2.68119 20.3222C1.89687 19.5397 1.55952 18.5544 1.40184 17.3843C1.24995 16.2573 1.24998 14.8242 1.25 13.0464V5.17508C1.25 3.55965 2.56262 2.25009 4.18182 2.25009L14.089 2.25005C14.8663 2.24963 15.4435 2.24931 15.9436 2.38298C17.2926 2.7436 18.3462 3.79483 18.7077 5.14068ZM15.4372 4.26652C15.22 4.20845 14.9259 4.20007 13.9541 4.20007H4.18138C3.64164 4.20007 3.2041 4.63659 3.2041 5.17507C3.2041 5.71354 3.64164 6.15006 4.18138 6.15006H15.9776C16.2901 6.15005 16.5897 6.15005 16.8763 6.15156C16.8674 5.89948 16.8505 5.76142 16.8193 5.64537C16.6386 4.97244 16.1117 4.44683 15.4372 4.26652ZM17.5 12C18.6046 12 19.5 12.8954 19.5 14C19.5 15.1046 18.6046 16 17.5 16C16.3954 16 15.5 15.1046 15.5 14C15.5 12.8954 16.3954 12 17.5 12Z"
                                            fill="currentColor" />
                                    </svg>
                                </span>
                                <h6>@lang('Available Balance')</h6>
                            </div>
                            <h2 class="mywallet-balance">{{ showAmount(auth('merchant')->user()->balance) }}</h2>
                        </div>

                        <button class="mywallet-btn" data-bs-toggle="modal" data-bs-target="#qr-modal">
                            <span class="thumb">
                                <img src="{{ $qrCodeUrl }}" alt="qr_code">
                            </span>
                        </button>

                    </div>

                    <div class="row g-3">
                        <div class="col-xsm-6 col-sm-6 col-lg-3">
                            <a href="{{ route('merchant.withdraw.history') }}" class="dashboard-widget">
                                <div class="dashboard-widget__link">
                                    <i class="fas fa-arrow-right"></i>
                                </div>
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M23.4033 2.10398C23.537 2.10679 23.6373 2.22673 23.617 2.35889C23.452 3.34916 23.3442 3.98246 23.2077 4.44748C23.0802 4.88221 22.9667 5.02274 22.8782 5.10124C22.7808 5.18763 22.6293 5.28171 22.1888 5.34258C21.7065 5.40924 21.0482 5.41621 19.9998 5.41621C18.9513 5.41621 18.293 5.40924 17.8107 5.34258C17.3703 5.28171 17.2187 5.18763 17.1213 5.10124C17.0328 5.02274 16.9195 4.88223 16.7918 4.44748C16.6556 3.98324 16.5479 3.35128 16.3833 2.36383C16.3637 2.22866 16.4665 2.10671 16.603 2.10384C17.5987 2.08299 18.6975 2.08299 19.9068 2.08301H20.0928C21.3048 2.08299 22.406 2.08299 23.4033 2.10398ZM13.4334 2.30809C13.6613 2.27746 13.8687 2.43881 13.9017 2.66639L13.9117 2.73589L13.9158 2.76211L13.9275 2.83236C14.0782 3.73666 14.2092 4.52328 14.3937 5.15188C14.5922 5.82824 14.8899 6.46334 15.4629 6.97169C16.0555 7.49748 16.738 7.71836 17.4692 7.81941C18.1585 7.91468 19.0092 7.91659 20.0005 7.91659C20.9918 7.91659 21.8425 7.91468 22.5318 7.81941C23.2628 7.71836 23.9455 7.49748 24.5382 6.97169C25.111 6.46334 25.4087 5.82824 25.6072 5.15188C25.7917 4.52328 25.9228 3.73666 26.0735 2.83238L26.0852 2.76213L26.1005 2.66281C26.135 2.43694 26.3415 2.27766 26.568 2.30809C28.2952 2.54031 29.7175 3.03281 30.8427 4.15804C31.9678 5.28328 32.4605 6.70563 32.6927 8.43274C32.9173 10.1046 32.9173 12.2362 32.9173 14.9071V25.093C32.9173 27.764 32.9173 29.8955 32.6927 31.5673C32.4605 33.2945 31.9678 34.7168 30.8427 35.842C29.7175 36.9673 28.2952 37.4598 26.568 37.692C24.8962 37.9168 22.7645 37.9167 20.0935 37.9167H19.9078C17.2368 37.9167 15.1052 37.9168 13.4334 37.692C11.7062 37.4598 10.2839 36.9673 9.15865 35.842C8.03342 34.7168 7.5409 33.2945 7.3087 31.5673C7.08394 29.8955 7.08395 27.764 7.08399 25.093V14.9071C7.08395 12.2362 7.08394 10.1045 7.3087 8.43274C7.5409 6.70563 8.03342 5.28328 9.15865 4.15804C10.2839 3.03281 11.7062 2.54031 13.4334 2.30809ZM17.084 33.333C17.084 32.6427 17.6437 32.083 18.334 32.083H21.6673C22.3577 32.083 22.9173 32.6427 22.9173 33.333C22.9173 34.0233 22.3577 34.583 21.6673 34.583H18.334C17.6437 34.583 17.084 34.0233 17.084 33.333Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Withdraw')</h5>
                                    <span class="dashboard-widget__text">
                                        @lang('Withdraw money from your account')
                                    </span>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M23.4033 2.10398C23.537 2.10679 23.6373 2.22673 23.617 2.35889C23.452 3.34916 23.3442 3.98246 23.2077 4.44748C23.0802 4.88221 22.9667 5.02274 22.8782 5.10124C22.7808 5.18763 22.6293 5.28171 22.1888 5.34258C21.7065 5.40924 21.0482 5.41621 19.9998 5.41621C18.9513 5.41621 18.293 5.40924 17.8107 5.34258C17.3703 5.28171 17.2187 5.18763 17.1213 5.10124C17.0328 5.02274 16.9195 4.88223 16.7918 4.44748C16.6556 3.98324 16.5479 3.35128 16.3833 2.36383C16.3637 2.22866 16.4665 2.10671 16.603 2.10384C17.5987 2.08299 18.6975 2.08299 19.9068 2.08301H20.0928C21.3048 2.08299 22.406 2.08299 23.4033 2.10398ZM13.4334 2.30809C13.6613 2.27746 13.8687 2.43881 13.9017 2.66639L13.9117 2.73589L13.9158 2.76211L13.9275 2.83236C14.0782 3.73666 14.2092 4.52328 14.3937 5.15188C14.5922 5.82824 14.8899 6.46334 15.4629 6.97169C16.0555 7.49748 16.738 7.71836 17.4692 7.81941C18.1585 7.91468 19.0092 7.91659 20.0005 7.91659C20.9918 7.91659 21.8425 7.91468 22.5318 7.81941C23.2628 7.71836 23.9455 7.49748 24.5382 6.97169C25.111 6.46334 25.4087 5.82824 25.6072 5.15188C25.7917 4.52328 25.9228 3.73666 26.0735 2.83238L26.0852 2.76213L26.1005 2.66281C26.135 2.43694 26.3415 2.27766 26.568 2.30809C28.2952 2.54031 29.7175 3.03281 30.8427 4.15804C31.9678 5.28328 32.4605 6.70563 32.6927 8.43274C32.9173 10.1046 32.9173 12.2362 32.9173 14.9071V25.093C32.9173 27.764 32.9173 29.8955 32.6927 31.5673C32.4605 33.2945 31.9678 34.7168 30.8427 35.842C29.7175 36.9673 28.2952 37.4598 26.568 37.692C24.8962 37.9168 22.7645 37.9167 20.0935 37.9167H19.9078C17.2368 37.9167 15.1052 37.9168 13.4334 37.692C11.7062 37.4598 10.2839 36.9673 9.15865 35.842C8.03342 34.7168 7.5409 33.2945 7.3087 31.5673C7.08394 29.8955 7.08395 27.764 7.08399 25.093V14.9071C7.08395 12.2362 7.08394 10.1045 7.3087 8.43274C7.5409 6.70563 8.03342 5.28328 9.15865 4.15804C10.2839 3.03281 11.7062 2.54031 13.4334 2.30809ZM17.084 33.333C17.084 32.6427 17.6437 32.083 18.334 32.083H21.6673C22.3577 32.083 22.9173 32.6427 22.9173 33.333C22.9173 34.0233 22.3577 34.583 21.6673 34.583H18.334C17.6437 34.583 17.084 34.0233 17.084 33.333Z"
                                            fill="currentColor" />
                                    </svg>

                                </div>
                            </a>
                        </div>
                        <div class="col-xsm-6 col-sm-6 col-lg-3">
                            <a href="{{ route('merchant.statement.history') }}" class="dashboard-widget">
                                <div class="dashboard-widget__link">
                                    <i class="fas fa-arrow-right"></i>
                                </div>
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M20.0007 2.08301C18.5572 2.08301 17.2668 2.54447 15.8737 3.32624C14.5238 4.08372 12.9771 5.20209 11.0321 6.60841L8.51705 8.42688C6.95615 9.55544 5.70945 10.4568 4.76914 11.2911C3.79824 12.1526 3.07189 13.0113 2.61115 14.0916C2.1494 15.1742 2.03774 16.2838 2.09967 17.5632C2.15945 18.7978 2.38839 20.2875 2.67387 22.145L3.19929 25.5642C3.60492 28.2038 3.9279 30.3057 4.4024 31.9433C4.89305 33.6365 5.58425 34.9808 6.81965 36.0083C8.04994 37.0317 9.51549 37.4873 11.3058 37.7048C13.0473 37.9163 15.2442 37.9163 18.0192 37.9163H18.1027L18.7512 37.9152V32.0732C17.492 31.9897 16.3045 31.3768 15.5598 30.3513L14.9757 29.5468C13.9031 28.0695 13.2562 26.3542 13.1084 24.565L12.9297 22.4027C12.8021 20.8593 14.0332 19.7138 15.4179 19.5935V16.6663C15.4179 15.976 15.9775 15.4163 16.6678 15.4163C17.3582 15.4163 17.9178 15.976 17.9178 16.6663V19.583H22.0845V16.6663C22.0845 15.976 22.6442 15.4163 23.3345 15.4163C24.0248 15.4163 24.5845 15.976 24.5845 16.6663V19.5928C25.9718 19.7102 27.207 20.8568 27.0792 22.4027L26.9005 24.565C26.7527 26.3542 26.1058 28.0695 25.0331 29.5468L24.449 30.3513C23.7031 31.3787 22.5128 31.9917 21.2512 32.0737V37.9103L25.003 37.9033L25.0183 37.903C28.6548 37.8517 31.2388 37.6243 33.1817 36.0083C34.4172 34.9808 35.1083 33.6365 35.599 31.9432C36.0735 30.3057 36.3965 28.2038 36.802 25.5642L37.3275 22.1448C37.613 20.2873 37.8418 18.7978 37.9017 17.5632C37.9637 16.2838 37.852 15.1742 37.3902 14.0916C36.9295 13.0113 36.2032 12.1526 35.2322 11.2911C34.2918 10.4569 33.0453 9.55551 31.4843 8.42697L28.9692 6.60839C27.0242 5.20207 25.4775 4.08372 24.1277 3.32624C22.7345 2.54447 21.4442 2.08301 20.0007 2.08301Z"
                                            fill="currentColor" />
                                    </svg>

                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Statement')</h5>
                                    <span class="dashboard-widget__text">
                                        @lang('View your statement')
                                    </span>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M20.0007 2.08301C18.5572 2.08301 17.2668 2.54447 15.8737 3.32624C14.5238 4.08372 12.9771 5.20209 11.0321 6.60841L8.51705 8.42688C6.95615 9.55544 5.70945 10.4568 4.76914 11.2911C3.79824 12.1526 3.07189 13.0113 2.61115 14.0916C2.1494 15.1742 2.03774 16.2838 2.09967 17.5632C2.15945 18.7978 2.38839 20.2875 2.67387 22.145L3.19929 25.5642C3.60492 28.2038 3.9279 30.3057 4.4024 31.9433C4.89305 33.6365 5.58425 34.9808 6.81965 36.0083C8.04994 37.0317 9.51549 37.4873 11.3058 37.7048C13.0473 37.9163 15.2442 37.9163 18.0192 37.9163H18.1027L18.7512 37.9152V32.0732C17.492 31.9897 16.3045 31.3768 15.5598 30.3513L14.9757 29.5468C13.9031 28.0695 13.2562 26.3542 13.1084 24.565L12.9297 22.4027C12.8021 20.8593 14.0332 19.7138 15.4179 19.5935V16.6663C15.4179 15.976 15.9775 15.4163 16.6678 15.4163C17.3582 15.4163 17.9178 15.976 17.9178 16.6663V19.583H22.0845V16.6663C22.0845 15.976 22.6442 15.4163 23.3345 15.4163C24.0248 15.4163 24.5845 15.976 24.5845 16.6663V19.5928C25.9718 19.7102 27.207 20.8568 27.0792 22.4027L26.9005 24.565C26.7527 26.3542 26.1058 28.0695 25.0331 29.5468L24.449 30.3513C23.7031 31.3787 22.5128 31.9917 21.2512 32.0737V37.9103L25.003 37.9033L25.0183 37.903C28.6548 37.8517 31.2388 37.6243 33.1817 36.0083C34.4172 34.9808 35.1083 33.6365 35.599 31.9432C36.0735 30.3057 36.3965 28.2038 36.802 25.5642L37.3275 22.1448C37.613 20.2873 37.8418 18.7978 37.9017 17.5632C37.9637 16.2838 37.852 15.1742 37.3902 14.0916C36.9295 13.0113 36.2032 12.1526 35.2322 11.2911C34.2918 10.4569 33.0453 9.55551 31.4843 8.42697L28.9692 6.60839C27.0242 5.20207 25.4775 4.08372 24.1277 3.32624C22.7345 2.54447 21.4442 2.08301 20.0007 2.08301Z"
                                            fill="currentColor" />
                                    </svg>

                                </div>
                            </a>
                        </div>
                        <div class="col-xsm-6 col-sm-6 col-lg-3">
                            <a href="{{ route('merchant.transactions') }}" class="dashboard-widget">
                                <div class="dashboard-widget__link">
                                    <i class="fas fa-arrow-right"></i>
                                </div>
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>

                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Transaction History')</h5>
                                    <span class="dashboard-widget__text">
                                        @lang('View your transaction history')
                                    </span>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                            </a>
                        </div>
                        <div class="col-xsm-6 col-sm-6 col-lg-3">
                            <a href="{{ route('ticket.index') }}" class="dashboard-widget">
                                <div class="dashboard-widget__link">
                                    <i class="fas fa-arrow-right"></i>
                                </div>
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path
                                            d="M9.37337 10.9737C9.7563 11.5482 9.60109 12.3242 9.02669 12.7072L6.99535 14.0614C6.24815 14.5595 5.75929 14.887 5.40177 15.1769C5.06455 15.4504 4.91785 15.6338 4.82619 15.8058C4.78955 15.8745 4.75639 15.9511 4.72724 16.0457L15.4982 22.5083C16.773 23.2733 17.6507 23.7981 18.38 24.1409C19.0837 24.4718 19.5559 24.5861 20 24.5861C20.4442 24.5861 20.9164 24.4718 21.62 24.1409C22.3494 23.7981 23.227 23.2733 24.5019 22.5083L35.2727 16.0458C35.2435 15.9511 35.2104 15.8745 35.1737 15.8058C35.082 15.6338 34.9354 15.4504 34.5982 15.1769C34.2407 14.887 33.7519 14.5595 33.0045 14.0614L30.9732 12.7072C30.3989 12.3242 30.2437 11.5482 30.6265 10.9737C31.0095 10.3993 31.7857 10.2441 32.36 10.6271L34.4369 12.0116C35.1262 12.4711 35.7137 12.8628 36.1729 13.2352C36.6624 13.6321 37.077 14.0616 37.3799 14.6298C37.7142 15.2569 37.8325 15.9022 37.8804 16.6018C37.9175 17.1436 37.9154 17.7863 37.9129 18.5314L37.9127 18.5723C37.9057 20.6716 37.886 22.8161 37.8319 24.9886L37.8295 25.0859C37.7677 27.5653 37.7177 29.5654 37.4339 31.1748C37.136 32.8638 36.5639 34.2383 35.3904 35.4118C34.2144 36.5878 32.8289 37.1589 31.1255 37.4564C29.4999 37.7404 27.4747 37.7909 24.9604 37.8538L24.8634 37.8563C21.6115 37.9374 18.3885 37.9374 15.1367 37.8563L15.0396 37.8538C12.5253 37.7909 10.5002 37.7404 8.87455 37.4564C7.1711 37.1589 5.78564 36.5878 4.60969 35.4118C3.43619 34.2383 2.86399 32.8638 2.5661 31.1748C2.28227 29.5654 2.23239 27.5653 2.17054 25.0859L2.1681 24.9886C2.11387 22.8161 2.09435 20.6718 2.08729 18.5723L2.08715 18.5318C2.08464 17.7864 2.08247 17.1436 2.11957 16.6017C2.16745 15.9022 2.28577 15.2569 2.62002 14.6298C2.92292 14.0616 3.33755 13.6321 3.82709 13.2352C4.28624 12.8628 4.87374 12.4712 5.56305 12.0116L7.63994 10.6271C8.21434 10.2441 8.99044 10.3993 9.37337 10.9737Z"
                                            fill="currentColor" />
                                        <path
                                            d="M25.0873 2.08301C26.5848 2.08296 27.8335 2.08293 28.8248 2.21619C29.8712 2.35688 30.8158 2.66633 31.5748 3.42544C32.334 4.18456 32.6435 5.12923 32.7842 6.17554C32.9175 7.16684 32.9173 8.41553 32.9173 9.91298V19.9997C32.9173 20.69 32.3577 21.2497 31.6673 21.2497C30.977 21.2497 30.4173 20.69 30.4173 19.9997V9.99968C30.4173 8.39299 30.4147 7.31373 30.3065 6.50866C30.203 5.73956 30.0243 5.41041 29.8072 5.19321C29.59 4.97601 29.2608 4.79731 28.4917 4.69391C27.6867 4.58568 26.6073 4.58301 25.0007 4.58301H15.0007C13.394 4.58301 12.3147 4.58568 11.5096 4.69391C10.7405 4.79731 10.4114 4.97601 10.1942 5.19321C9.97699 5.41041 9.79829 5.73956 9.69489 6.50866C9.58665 7.31373 9.58399 8.39299 9.58399 9.99968V19.9997C9.58399 20.69 9.02435 21.2497 8.33399 21.2497C7.64364 21.2497 7.08399 20.69 7.08399 19.9997V9.91301C7.08394 8.41556 7.0839 7.16684 7.21717 6.17554C7.35785 5.12923 7.6673 4.18456 8.42642 3.42544C9.18554 2.66633 10.1302 2.35688 11.1765 2.21619C12.1678 2.08293 13.4165 2.08296 14.9139 2.08301H25.0873Z"
                                            fill="currentColor" />
                                        <path
                                            d="M15.6548 9.37372C17.358 8.40639 18.9505 8.69915 20.0035 9.34062C21.0563 8.69915 22.6488 8.40639 24.352 9.37372C25.7363 10.16 26.455 11.7724 26.2032 13.5106C25.9512 15.2512 24.7645 17.0457 22.5403 18.57L22.4375 18.6407C21.7498 19.1138 21.0668 19.5837 20.0035 19.5837C18.94 19.5837 18.257 19.1138 17.5693 18.6407L17.4665 18.57C15.2424 17.0457 14.0557 15.2512 13.8036 13.5106C13.5518 11.7724 14.2705 10.16 15.6548 9.37372Z"
                                            fill="currentColor" />
                                    </svg>

                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Support Ticket')</h5>
                                    <span class="dashboard-widget__text">
                                        @lang('View your support ticket')
                                    </span>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path
                                            d="M9.37337 10.9737C9.7563 11.5482 9.60109 12.3242 9.02669 12.7072L6.99535 14.0614C6.24815 14.5595 5.75929 14.887 5.40177 15.1769C5.06455 15.4504 4.91785 15.6338 4.82619 15.8058C4.78955 15.8745 4.75639 15.9511 4.72724 16.0457L15.4982 22.5083C16.773 23.2733 17.6507 23.7981 18.38 24.1409C19.0837 24.4718 19.5559 24.5861 20 24.5861C20.4442 24.5861 20.9164 24.4718 21.62 24.1409C22.3494 23.7981 23.227 23.2733 24.5019 22.5083L35.2727 16.0458C35.2435 15.9511 35.2104 15.8745 35.1737 15.8058C35.082 15.6338 34.9354 15.4504 34.5982 15.1769C34.2407 14.887 33.7519 14.5595 33.0045 14.0614L30.9732 12.7072C30.3989 12.3242 30.2437 11.5482 30.6265 10.9737C31.0095 10.3993 31.7857 10.2441 32.36 10.6271L34.4369 12.0116C35.1262 12.4711 35.7137 12.8628 36.1729 13.2352C36.6624 13.6321 37.077 14.0616 37.3799 14.6298C37.7142 15.2569 37.8325 15.9022 37.8804 16.6018C37.9175 17.1436 37.9154 17.7863 37.9129 18.5314L37.9127 18.5723C37.9057 20.6716 37.886 22.8161 37.8319 24.9886L37.8295 25.0859C37.7677 27.5653 37.7177 29.5654 37.4339 31.1748C37.136 32.8638 36.5639 34.2383 35.3904 35.4118C34.2144 36.5878 32.8289 37.1589 31.1255 37.4564C29.4999 37.7404 27.4747 37.7909 24.9604 37.8538L24.8634 37.8563C21.6115 37.9374 18.3885 37.9374 15.1367 37.8563L15.0396 37.8538C12.5253 37.7909 10.5002 37.7404 8.87455 37.4564C7.1711 37.1589 5.78564 36.5878 4.60969 35.4118C3.43619 34.2383 2.86399 32.8638 2.5661 31.1748C2.28227 29.5654 2.23239 27.5653 2.17054 25.0859L2.1681 24.9886C2.11387 22.8161 2.09435 20.6718 2.08729 18.5723L2.08715 18.5318C2.08464 17.7864 2.08247 17.1436 2.11957 16.6017C2.16745 15.9022 2.28577 15.2569 2.62002 14.6298C2.92292 14.0616 3.33755 13.6321 3.82709 13.2352C4.28624 12.8628 4.87374 12.4712 5.56305 12.0116L7.63994 10.6271C8.21434 10.2441 8.99044 10.3993 9.37337 10.9737Z"
                                            fill="currentColor" />
                                        <path
                                            d="M25.0873 2.08301C26.5848 2.08296 27.8335 2.08293 28.8248 2.21619C29.8712 2.35688 30.8158 2.66633 31.5748 3.42544C32.334 4.18456 32.6435 5.12923 32.7842 6.17554C32.9175 7.16684 32.9173 8.41553 32.9173 9.91298V19.9997C32.9173 20.69 32.3577 21.2497 31.6673 21.2497C30.977 21.2497 30.4173 20.69 30.4173 19.9997V9.99968C30.4173 8.39299 30.4147 7.31373 30.3065 6.50866C30.203 5.73956 30.0243 5.41041 29.8072 5.19321C29.59 4.97601 29.2608 4.79731 28.4917 4.69391C27.6867 4.58568 26.6073 4.58301 25.0007 4.58301H15.0007C13.394 4.58301 12.3147 4.58568 11.5096 4.69391C10.7405 4.79731 10.4114 4.97601 10.1942 5.19321C9.97699 5.41041 9.79829 5.73956 9.69489 6.50866C9.58665 7.31373 9.58399 8.39299 9.58399 9.99968V19.9997C9.58399 20.69 9.02435 21.2497 8.33399 21.2497C7.64364 21.2497 7.08399 20.69 7.08399 19.9997V9.91301C7.08394 8.41556 7.0839 7.16684 7.21717 6.17554C7.35785 5.12923 7.6673 4.18456 8.42642 3.42544C9.18554 2.66633 10.1302 2.35688 11.1765 2.21619C12.1678 2.08293 13.4165 2.08296 14.9139 2.08301H25.0873Z"
                                            fill="currentColor" />
                                        <path
                                            d="M15.6548 9.37372C17.358 8.40639 18.9505 8.69915 20.0035 9.34062C21.0563 8.69915 22.6488 8.40639 24.352 9.37372C25.7363 10.16 26.455 11.7724 26.2032 13.5106C25.9512 15.2512 24.7645 17.0457 22.5403 18.57L22.4375 18.6407C21.7498 19.1138 21.0668 19.5837 20.0035 19.5837C18.94 19.5837 18.257 19.1138 17.5693 18.6407L17.4665 18.57C15.2424 17.0457 14.0557 15.2512 13.8036 13.5106C13.5518 11.7724 14.2705 10.16 15.6548 9.37372Z"
                                            fill="currentColor" />
                                    </svg>

                                </div>
                            </a>
                        </div>
                    </div>

                </div>
            </div>


            <div class="table-wrapper">
                <div class="table-wrapper-header">
                    <h4>@lang('Latest Transactions')</h4>
                    <div class="table-search-right">
                        <form class="table-search no-submit-loader">
                            <input type="search" name="search" class="form-control form--control"
                                value="{{ request()->search }}" placeholder="@lang('Search...')">
                            <button class="icon px-3" type="submit">
                                <i class="fa fa-search"></i>
                            </button>
                        </form>
                    </div>
                </div>
                <div class="table-wrapper-body">
                    <table class="table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Trx')</th>
                                <th>@lang('Transacted')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Charge')</th>
                                <th>@lang('Post Balance')</th>
                                <th>@lang('Detail')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactions as $trx)
                                <tr>
                                    <td>
                                        <strong>{{ $trx->trx }}</strong>
                                    </td>
                                    <td>
                                        {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                                    </td>
                                    <td>
                                        <span
                                            class="fw-bold @if ($trx->trx_type == '+') text--success @else text--danger @endif">
                                            {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                                        </span>
                                    </td>
                                    <td>
                                        {{ showAmount($trx->charge) }}
                                    </td>
                                    <td>
                                        {{ showAmount($trx->post_balance) }}
                                    </td>
                                    <td>{{ __($trx->details) }}</td>
                                </tr>
                            @empty
                                @include('Template::partials.empty_message')
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="table-wrapper-footer d-none"></div>
            </div>
        </div>
    </div>


    @if (auth('merchant')->user()->kv == Status::KYC_UNVERIFIED && auth('merchant')->user()->kyc_rejection_reason)
        <div class="modal fade custom--modal" id="kycRejectionReason">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>{{ auth('merchant')->user()->kyc_rejection_reason }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif



    <div class="modal custom--modal fade qr-modal" id="qr-modal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-img "
                    data-background-image="{{ asset($activeTemplateTrue . 'images/modal_shape.png') }}">
                    <h4 class="modal-title">@lang('My QR Code')</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="qr-modal-thumb text-center">
                        <img class="mx-auto" src="{{ $qrCodeUrl }}" alt="QR">
                    </div>
                    <p class="qr-modal-note fs-14">
                        <i>
                            @lang('Scan this QR code to make your transactions quick and easy!')
                        </i>
                    </p>
                    <div class="qr-modal-form mt-4 mb-4">
                        <h6 class="title">@lang('My Number')</h6>
                        <div class="number">
                            @foreach (str_split(auth('merchant')->user()->mobile) as $digit)
                                <span>{{ $digit }}</span>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-img justify-content-center"
                    data-background-image="{{ asset($activeTemplateTrue . 'images/modal_shape.png') }}">
                    <h4 class="">{{ __(gs('site_name')) }}</h4>
                </div>
            </div>
        </div>
    </div>
@endsection
