@extends($activeTemplate . 'layouts.merchant')
@section('content')
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="show-filter mb-3 text-end">
                <button type="button" class="btn btn--base showFilterBtn"><i class="las la-filter"></i>
                    @lang('Filter')
                </button>
            </div>
            <div class="card responsive-filter-card mb-4 custom--card">
                <div class="card-body">
                    <form method="get">
                        <div class="d-flex flex-wrap gap-2 flex-column flex-md-row">
                            <div class="flex-fill select2-parent">
                                <label class="form-label d-block">@lang('Month')</label>
                                <select name="month" class="form-select form--control select2"
                                    data-minimum-results-for-search="-1">
                                    @for ($m = 1; $m <= 12; $m++)
                                        @php $monthName = \Carbon\Carbon::create()->month($m)->format('F'); @endphp
                                        <option value="{{ $m }}" @selected($m == $month)>
                                            {{ $monthName }}
                                        </option>
                                    @endfor
                                </select>
                            </div>
                            <div class="flex-fill select2-parent">
                                <label class="form-label d-block">@lang('Year')</label>
                                <select name="year" class="form-select form--control select2"
                                    data-minimum-results-for-search="-1">
                                    @for ($y = now()->year; $y >= now()->year - 10; $y--)
                                        <option value="{{ $y }}" @selected($y == $year)>
                                            {{ $y }}
                                        </option>
                                    @endfor
                                </select>
                            </div>
                            <div class="flex-fill align-self-end">
                                <button class="btn btn--base w-100">
                                    <i class="las la-filter"></i>
                                    @lang('Filter')
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card custom--card">
                <div class="card-body p-0">
                    <div class="row g-3">
                        <div class="col-xsm-6 col-sm-6 col-lg-3">
                            <div class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title"> {{ showAmount(auth('merchant')->user()->balance) }}
                                    </h5>
                                    <span class="dashboard-widget__text">
                                        @lang('Available Balance')
                                    </span>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                            </div>
                        </div>

                        <div class="col-xsm-6 col-sm-6 col-lg-3">
                            <div class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title"> {{ showAmount($startingBalance) }}</h5>
                                    <span class="dashboard-widget__text">
                                        @lang('Starting Balance')
                                    </span>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                            </div>
                        </div>

                        <div class="col-xsm-6 col-sm-6 col-lg-3">
                            <div class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title"> {{ showAmount($totalTransactionAmount) }}</h5>
                                    <span class="dashboard-widget__text">
                                        @lang('Total Transaction')
                                    </span>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                            </div>
                        </div>


                        <div class="col-xsm-6 col-sm-6 col-lg-3">
                            <div class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title"> {{ showAmount($totalCharge) }}</h5>
                                    <span class="dashboard-widget__text">
                                        @lang('Total Charge')
                                    </span>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                            fill="currentColor" />
                                        <path
                                            d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                            fill="currentColor" />
                                    </svg>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>

            </div>


            <div class="table-wrapper mt-4">
                <div class="table-wrapper-header">
                    <h4>@lang('Transactions')</h4>
                    <div class="table-search-right">
                        <form class="table-search no-submit-loader">
                            <input type="search" name="search" class="form-control form--control"
                                value="{{ request()->search }}" placeholder="@lang('Search...')">
                            <button class="icon px-3" type="submit">
                                <i class="fa fa-search"></i>
                            </button>
                        </form>
                    </div>
                </div>
                <div class="table-wrapper-body">
                    <table class="table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Trx')</th>
                                <th>@lang('Transacted')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Charge')</th>
                                <th>@lang('Post Balance')</th>
                                <th>@lang('Detail')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactionHistory as $trx)
                                <tr>
                                    <td>
                                        <strong>{{ $trx->trx }}</strong>
                                    </td>
                                    <td>
                                        {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                                    </td>
                                    <td>
                                        <span
                                            class="fw-bold @if ($trx->trx_type == '+') text--success @else text--danger @endif">
                                            {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                                        </span>
                                    </td>
                                    <td>
                                        {{ showAmount($trx->charge) }}
                                    </td>
                                    <td>
                                        {{ showAmount($trx->post_balance) }}
                                    </td>
                                    <td>{{ __($trx->details) }}</td>
                                </tr>
                            @empty
                                @include('Template::partials.empty_message')
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if ($transactionHistory->hasPages())
                    {{ paginateLinks($transactionHistory) }}
                @endif
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .select2-container {
            width: 100% !important;
        }
    </style>
@endpush
