@extends($activeTemplate . 'layouts.master')
@section('content')
    @php
        $kyc = getContent('kyc.content', true);
    @endphp
    <div class="notice"></div>
    <div class="row justify-content-center gy-4">
        @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
            <div class="col-12">
                <div class="alert alert--danger" role="alert">
                    <div class="alert__icon">
                        <i class="fa fa-times"></i>
                    </div>
                    <div class="alert__content">
                        <h6 class="alert__title">@lang('KYC Verification Rejected')</h6>
                        <p class="alert__desc">
                            {{ __(@$kyc->data_values->reject) }}
                            <a href="{{ route('user.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a>,
                            <button type="button" class="text--danger" href="{{ route('user.kyc.form') }}"
                                data-bs-toggle="modal" data-bs-target="#kycRejectionReason">@lang('Show Reject Reason')</button>.
                        </p>
                    </div>
                </div>
            </div>
        @elseif(auth()->user()->kv == Status::KYC_UNVERIFIED)
            <div class="col-12">
                <div class="alert alert--info" role="alert">
                    <div class="alert__icon">
                        <i class="fa fa-info"></i>
                    </div>
                    <div class="alert__content">
                        <h6 class="alert__title">@lang('KYC Verification Required')</h6>
                        <p class="alert__desc">
                            {{ __(@$kyc->data_values->required) }} <a
                                href="{{ route('user.kyc.form') }}">@lang('Click Here to Submit Documents')</a>
                        </p>
                    </div>
                </div>
            </div>
        @elseif(auth()->user()->kv == Status::KYC_PENDING)
            <div class="col-12">
                <div class="alert alert--warning" role="alert">
                    <div class="alert__icon">
                        <i class="fa fa-info"></i>
                    </div>
                    <div class="alert__content">
                        <h6 class="alert__title">@lang('KYC Verification Pending')</h6>
                        <p class="alert__desc">
                            {{ __(@$kyc->data_values->pending) }}
                            <a href="{{ route('user.kyc.data') }}">@lang('See KYC Data')
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        @endif
        <div class="col-lg-12">
            <div class="card custom--card mb-4">
                <div class="card-body">
                    <div class="mywallet">
                        <div class="mywallet-left">
                            <div class="mywallet-title">
                                <span class="icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M18.7077 5.14068C18.7931 5.4585 18.8239 5.80758 18.835 6.21961C18.981 6.2325 19.1214 6.24776 19.2563 6.26586C20.1631 6.38748 20.9639 6.65265 21.6051 7.29235C22.2463 7.93206 22.512 8.73099 22.6339 9.63562C22.7501 10.4973 22.75 11.586 22.75 12.9063V14.9938C22.75 16.3141 22.7501 17.4028 22.6339 18.2645C22.512 19.1691 22.2463 19.968 21.6051 20.6077C20.9639 21.2474 20.1631 21.5126 19.2563 21.6342C18.3927 21.7501 17.3014 21.75 15.978 21.75H9.97398C8.19196 21.75 6.75559 21.75 5.6259 21.5985C4.45303 21.4412 3.4655 21.1046 2.68119 20.3222C1.89687 19.5397 1.55952 18.5544 1.40184 17.3843C1.24995 16.2573 1.24998 14.8242 1.25 13.0464V5.17508C1.25 3.55965 2.56262 2.25009 4.18182 2.25009L14.089 2.25005C14.8663 2.24963 15.4435 2.24931 15.9436 2.38298C17.2926 2.7436 18.3462 3.79483 18.7077 5.14068ZM15.4372 4.26652C15.22 4.20845 14.9259 4.20007 13.9541 4.20007H4.18138C3.64164 4.20007 3.2041 4.63659 3.2041 5.17507C3.2041 5.71354 3.64164 6.15006 4.18138 6.15006H15.9776C16.2901 6.15005 16.5897 6.15005 16.8763 6.15156C16.8674 5.89948 16.8505 5.76142 16.8193 5.64537C16.6386 4.97244 16.1117 4.44683 15.4372 4.26652ZM17.5 12C18.6046 12 19.5 12.8954 19.5 14C19.5 15.1046 18.6046 16 17.5 16C16.3954 16 15.5 15.1046 15.5 14C15.5 12.8954 16.3954 12 17.5 12Z"
                                            fill="currentColor" />
                                    </svg>
                                </span>
                                <h6>@lang('Available Balance')</h6>
                            </div>
                            <h2 class="mywallet-balance">{{ showAmount(auth()->user()->balance) }}</h2>
                        </div>
                        <button class="mywallet-btn" data-bs-toggle="modal" data-bs-target="#qr-modal">
                            <span class="thumb">
                                <img src="{{ $qrCodeUrl }}" alt="qr_code">
                            </span>
                        </button>
                    </div>
                    <div class="dashboard-widget-wrapper">
                        @if (moduleIsEnable('add_money', $enableModules))
                            <a href="{{ route('user.deposit.index') }}" class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <g clip-path="url(#clip0_6728_954)">
                                            <path
                                                d="M9.16602 7.91699H10.416C11.1063 7.91699 11.666 8.47666 11.666 9.16699M9.16602 7.91699H7.91602C7.22566 7.91699 6.66602 8.47666 6.66602 9.16699V9.58366C6.66602 10.274 7.22566 10.8337 7.91602 10.8337H10.416C11.1063 10.8337 11.666 11.3933 11.666 12.0837V12.5003C11.666 13.1907 11.1063 13.7503 10.416 13.7503H9.16602M9.16602 7.91699V6.66699M9.16602 13.7503H7.91602C7.22566 13.7503 6.66602 13.1907 6.66602 12.5003M9.16602 13.7503V15.0003"
                                                stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M9.99935 3.37878C 9.72577 3.34853 9.44768 3.33301 9.16602 3.33301C5.02388 3.33301 1.66602 6.69087 1.66602 10.833C1.66602 14.9751 5.02388 18.333 9.16602 18.333C13.3081 18.333 16.666 14.9751 16.666 10.833C16.666 10.5513 16.6505 10.2733 16.6203 9.99967"
                                                stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path d="M15.4167 1.66699V7.50033M18.3333 4.58366H12.5" stroke="currentColor"
                                                stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                        </g>
                                        <defs>
                                            <clipPath>
                                                <rect width="20" height="20" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>

                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Add Money')</h5>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <g clip-path="url(#clip0_6728_954)">
                                            <path
                                                d="M9.16602 7.91699H10.416C11.1063 7.91699 11.666 8.47666 11.666 9.16699M9.16602 7.91699H7.91602C7.22566 7.91699 6.66602 8.47666 6.66602 9.16699V9.58366C6.66602 10.274 7.22566 10.8337 7.91602 10.8337H10.416C11.1063 10.8337 11.666 11.3933 11.666 12.0837V12.5003C11.666 13.1907 11.1063 13.7503 10.416 13.7503H9.16602M9.16602 7.91699V6.66699M9.16602 13.7503H7.91602C7.22566 13.7503 6.66602 13.1907 6.66602 12.5003M9.16602 13.7503V15.0003"
                                                stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M9.99935 3.37878C 9.72577 3.34853 9.44768 3.33301 9.16602 3.33301C5.02388 3.33301 1.66602 6.69087 1.66602 10.833C1.66602 14.9751 5.02388 18.333 9.16602 18.333C13.3081 18.333 16.666 14.9751 16.666 10.833C16.666 10.5513 16.6505 10.2733 16.6203 9.99967"
                                                stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path d="M15.4167 1.66699V7.50033M18.3333 4.58366H12.5" stroke="currentColor"
                                                stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                        </g>
                                        <defs>
                                            <clipPath>
                                                <rect width="20" height="20" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>

                                </div>
                            </a>
                        @endif
                        @if (moduleIsEnable('send_money', $enableModules))
                            <a href="{{ route('user.send.money.create') }}" class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <path
                                            d="M9.935 3.9917C13.9136 2.63538 15.9028 1.95722 16.9728 3.02718C18.0427 4.09714 17.3646 6.08643 16.0083 10.065L15.0847 12.7743C14.0431 15.8298 13.5222 17.3576 12.6637 17.484C12.4329 17.518 12.194 17.4976 11.9656 17.4243C11.1162 17.1516 10.6672 15.5408 9.76925 12.3192C9.57008 11.6046 9.4705 11.2473 9.24366 10.9743C9.17783 10.8952 9.10483 10.8222 9.02566 10.7563C8.75275 10.5295 8.39541 10.4299 7.68087 10.2308C4.45926 9.33275 2.84845 8.88375 2.57575 8.03439C2.50243 7.80603 2.48197 7.56711 2.51596 7.33629C2.6424 6.47777 4.17016 5.95695 7.22566 4.91532L9.935 3.9917Z"
                                            stroke="currentColor" stroke-width="1.5" />
                                    </svg>

                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Send Money')</h5>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <path
                                            d="M9.935 3.9917C13.9136 2.63538 15.9028 1.95722 16.9728 3.02718C18.0427 4.09714 17.3646 6.08643 16.0083 10.065L15.0847 12.7743C14.0431 15.8298 13.5222 17.3576 12.6637 17.484C12.4329 17.518 12.194 17.4976 11.9656 17.4243C11.1162 17.1516 10.6672 15.5408 9.76925 12.3192C9.57008 11.6046 9.4705 11.2473 9.24366 10.9743C9.17783 10.8952 9.10483 10.8222 9.02566 10.7563C8.75275 10.5295 8.39541 10.4299 7.68087 10.2308C4.45926 9.33275 2.84845 8.88375 2.57575 8.03439C2.50243 7.80603 2.48197 7.56711 2.51596 7.33629C2.6424 6.47777 4.17016 5.95695 7.22566 4.91532L9.935 3.9917Z"
                                            stroke="currentColor" stroke-width="1.5" />
                                    </svg>
                                </div>
                            </a>
                        @endif
                        @if (moduleIsEnable('make_payment', $enableModules))
                            <a href="{{ route('user.make.payment.create') }}" class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <path
                                            d="M3.33398 15.5385V6.71221C3.33398 4.33387 3.33398 3.1447 4.06622 2.40585C4.79845 1.66699 5.97696 1.66699 8.33398 1.66699H11.6673C14.0243 1.66699 15.2028 1.66699 15.9351 2.40585C16.6673 3.1447 16.6673 4.33387 16.6673 6.71221V15.5385C16.6673 16.7982 16.6673 17.4281 16.2823 17.676C15.6532 18.0812 14.6807 17.2315 14.1916 16.9231C13.7874 16.6682 13.5854 16.5407 13.3611 16.5334C13.1187 16.5254 12.9131 16.6477 12.4764 16.9231L10.884 17.9273C10.4544 18.1982 10.2397 18.3337 10.0007 18.3337C9.76165 18.3337 9.5469 18.1982 9.11732 17.9273L7.52493 16.9231C7.12078 16.6682 6.9187 16.5407 6.69443 16.5334C6.45208 16.5254 6.24643 16.6477 5.80971 16.9231C5.32061 17.2315 4.34804 18.0812 3.71894 17.676C3.33398 17.4281 3.33398 16.7982 3.33398 15.5385Z"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                        <path d="M13.3327 5H6.66602" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                        <path d="M8.33268 8.33301H6.66602" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                        <path
                                            d="M12.084 8.22917C11.3937 8.22917 10.834 8.71883 10.834 9.32292C10.834 9.927 11.3937 10.4167 12.084 10.4167C12.7743 10.4167 13.334 10.9063 13.334 11.5104C13.334 12.1145 12.7743 12.6042 12.084 12.6042M12.084 8.22917C12.6282 8.22917 13.0912 8.5335 13.2628 8.95833M12.084 8.22917V7.5M12.084 12.6042C11.5397 12.6042 11.0767 12.2998 10.9052 11.875M12.084 12.6042V13.3333"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                    </svg>
                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Payment')</h5>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <path
                                            d="M3.33398 15.5385V6.71221C3.33398 4.33387 3.33398 3.1447 4.06622 2.40585C4.79845 1.66699 5.97696 1.66699 8.33398 1.66699H11.6673C14.0243 1.66699 15.2028 1.66699 15.9351 2.40585C16.6673 3.1447 16.6673 4.33387 16.6673 6.71221V15.5385C16.6673 16.7982 16.6673 17.4281 16.2823 17.676C15.6532 18.0812 14.6807 17.2315 14.1916 16.9231C13.7874 16.6682 13.5854 16.5407 13.3611 16.5334C13.1187 16.5254 12.9131 16.6477 12.4764 16.9231L10.884 17.9273C10.4544 18.1982 10.2397 18.3337 10.0007 18.3337C9.76165 18.3337 9.5469 18.1982 9.11732 17.9273L7.52493 16.9231C7.12078 16.6682 6.9187 16.5407 6.69443 16.5334C6.45208 16.5254 6.24643 16.6477 5.80971 16.9231C5.32061 17.2315 4.34804 18.0812 3.71894 17.676C3.33398 17.4281 3.33398 16.7982 3.33398 15.5385Z"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                        <path d="M13.3327 5H6.66602" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                        <path d="M8.33268 8.33301H6.66602" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                        <path
                                            d="M12.084 8.22917C11.3937 8.22917 10.834 8.71883 10.834 9.32292C10.834 9.927 11.3937 10.4167 12.084 10.4167C12.7743 10.4167 13.334 10.9063 13.334 11.5104C13.334 12.1145 12.7743 12.6042 12.084 12.6042M12.084 8.22917C12.6282 8.22917 13.0912 8.5335 13.2628 8.95833M12.084 8.22917V7.5M12.084 12.6042C11.5397 12.6042 11.0767 12.2998 10.9052 11.875M12.084 12.6042V13.3333"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                    </svg>
                                </div>
                            </a>
                        @endif
                        @if (moduleIsEnable('request_money', $enableModules))
                            <a href="{{ route('user.request.money.create') }}" class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <g clip-path="url(#clip0_6728_984)">
                                            <path
                                                d="M10.4337 2.5H9.59868C9.1296 2.50697 8.66252 2.52569 8.20367 2.55614C4.7108 2.7879 1.92855 5.60449 1.69962 9.1405C1.65482 9.83242 1.65482 10.549 1.69962 11.241C1.783 12.5288 2.35359 13.7212 3.02534 14.7282C3.41537 15.433 3.15797 16.3128 2.75171 17.0812C2.45878 17.6353 2.31232 17.9124 2.42992 18.1125C2.54752 18.3127 2.8102 18.3191 3.33557 18.3318C4.37452 18.3571 5.07511 18.0631 5.63122 17.6537C5.94663 17.4216 6.10433 17.3055 6.21302 17.2922C6.32172 17.2788 6.53562 17.3667 6.96335 17.5426C7.34778 17.7007 7.79415 17.7982 8.20367 17.8253C9.39285 17.9042 10.637 17.9044 11.8286 17.8253C15.1802 17.603 17.9176 15.0007 18.3327 11.6667"
                                                stroke="currentColor " stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M12.991 7.20715C12.467 7.51428 11.0932 8.14141 11.93 8.92616C12.3387 9.30949 12.794 9.58366 13.3664 9.58366H16.6324C17.2047 9.58366 17.66 9.30949 18.0688 8.92616C18.9055 8.14141 17.5317 7.51428 17.0077 7.20715C15.779 6.48694 14.2198 6.48694 12.991 7.20715Z"
                                                stroke="currentColor" stroke-width="1.5" />
                                            <path
                                                d="M16.6673 3.33366C16.6673 4.25413 15.9212 5.00033 15.0007 5.00033C14.0802 5.00033 13.334 4.25413 13.334 3.33366C13.334 2.41318 14.0802 1.66699 15.0007 1.66699C15.9212 1.66699 16.6673 2.41318 16.6673 3.33366Z"
                                                stroke="currentColor" stroke-width="1.5" />
                                            <path d="M7.08398 12.4997H12.9173M7.08398 8.33301H8.75065"
                                                stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                        </g>
                                        <defs>
                                            <clipPath>
                                                <rect width="20" height="20" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Request Money')</h5>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <g clip-path="url(#clip0_6728_984)">
                                            <path
                                                d="M10.4337 2.5H9.59868C9.1296 2.50697 8.66252 2.52569 8.20367 2.55614C4.7108 2.7879 1.92855 5.60449 1.69962 9.1405C1.65482 9.83242 1.65482 10.549 1.69962 11.241C1.783 12.5288 2.35359 13.7212 3.02534 14.7282C3.41537 15.433 3.15797 16.3128 2.75171 17.0812C2.45878 17.6353 2.31232 17.9124 2.42992 18.1125C2.54752 18.3127 2.8102 18.3191 3.33557 18.3318C4.37452 18.3571 5.07511 18.0631 5.63122 17.6537C5.94663 17.4216 6.10433 17.3055 6.21302 17.2922C6.32172 17.2788 6.53562 17.3667 6.96335 17.5426C7.34778 17.7007 7.79415 17.7982 8.20367 17.8253C9.39285 17.9042 10.637 17.9044 11.8286 17.8253C15.1802 17.603 17.9176 15.0007 18.3327 11.6667"
                                                stroke="currentColor " stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M12.991 7.20715C12.467 7.51428 11.0932 8.14141 11.93 8.92616C12.3387 9.30949 12.794 9.58366 13.3664 9.58366H16.6324C17.2047 9.58366 17.66 9.30949 18.0688 8.92616C18.9055 8.14141 17.5317 7.51428 17.0077 7.20715C15.779 6.48694 14.2198 6.48694 12.991 7.20715Z"
                                                stroke="currentColor" stroke-width="1.5" />
                                            <path
                                                d="M16.6673 3.33366C16.6673 4.25413 15.9212 5.00033 15.0007 5.00033C14.0802 5.00033 13.334 4.25413 13.334 3.33366C13.334 2.41318 14.0802 1.66699 15.0007 1.66699C15.9212 1.66699 16.6673 2.41318 16.6673 3.33366Z"
                                                stroke="currentColor" stroke-width="1.5" />
                                            <path d="M7.08398 12.4997H12.9173M7.08398 8.33301H8.75065"
                                                stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                        </g>
                                        <defs>
                                            <clipPath>
                                                <rect width="20" height="20" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                            </a>
                        @endif
                        @if (moduleIsEnable('cash_out', $enableModules))
                            <a href="{{ route('user.cash.out.create') }}" class="dashboard-widget">
                                <div class="dashboard-widget__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <path
                                            d="M16.4551 10.8337C17.1142 9.88882 17.5007 8.73966 17.5007 7.50032C17.5007 4.27867 14.889 1.66699 11.6673 1.66699C8.44565 1.66699 5.83398 4.27866 5.83398 7.50032C5.83398 8.39499 6.03539 9.24257 6.39534 10.0003"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                        <path
                                            d="M11.6667 5.00033C10.7462 5.00033 10 5.55997 10 6.25033C10 6.94068 10.7462 7.50033 11.6667 7.50033C12.5872 7.50033 13.3333 8.05997 13.3333 8.75033C13.3333 9.44066 12.5872 10.0003 11.6667 10.0003M11.6667 5.00033C12.3923 5.00033 13.0097 5.34816 13.2385 5.83366M11.6667 5.00033V4.16699M11.6667 10.0003C10.941 10.0003 10.3237 9.65249 10.0948 9.16699M11.6667 10.0003V10.8337"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                        <path
                                            d="M2.5 11.667H4.49568C4.74081 11.667 4.98257 11.7222 5.20181 11.8283L6.90346 12.6517C7.1227 12.7577 7.36446 12.8129 7.60958 12.8129H8.47842C9.31875 12.8129 10 13.4722 10 14.2853C10 14.3182 9.9775 14.3471 9.94483 14.3561L7.82739 14.9416C7.44756 15.0466 7.04083 15.01 6.6875 14.839L4.86843 13.9589M10 13.7503L13.8273 12.5744C14.5058 12.363 15.2392 12.6137 15.6642 13.2022C15.9716 13.6277 15.8464 14.2372 15.3987 14.4955L9.13575 18.1091C8.73742 18.3389 8.26745 18.395 7.8293 18.265L2.5 16.6836"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </div>
                                <div class="dashboard-widget__content">
                                    <h5 class="dashboard-widget__title">@lang('Cash Out')</h5>
                                </div>
                                <div class="dashboard-widget__shape">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 20 20" fill="none">
                                        <path
                                            d="M16.4551 10.8337C17.1142 9.88882 17.5007 8.73966 17.5007 7.50032C17.5007 4.27867 14.889 1.66699 11.6673 1.66699C8.44565 1.66699 5.83398 4.27866 5.83398 7.50032C5.83398 8.39499 6.03539 9.24257 6.39534 10.0003"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                        <path
                                            d="M11.6667 5.00033C10.7462 5.00033 10 5.55997 10 6.25033C10 6.94068 10.7462 7.50033 11.6667 7.50033C12.5872 7.50033 13.3333 8.05997 13.3333 8.75033C13.3333 9.44066 12.5872 10.0003 11.6667 10.0003M11.6667 5.00033C12.3923 5.00033 13.0097 5.34816 13.2385 5.83366M11.6667 5.00033V4.16699M11.6667 10.0003C10.941 10.0003 10.3237 9.65249 10.0948 9.16699M11.6667 10.0003V10.8337"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                        <path
                                            d="M2.5 11.667H4.49568C4.74081 11.667 4.98257 11.7222 5.20181 11.8283L6.90346 12.6517C7.1227 12.7577 7.36446 12.8129 7.60958 12.8129H8.47842C9.31875 12.8129 10 13.4722 10 14.2853C10 14.3182 9.9775 14.3471 9.94483 14.3561L7.82739 14.9416C7.44756 15.0466 7.04083 15.01 6.6875 14.839L4.86843 13.9589M10 13.7503L13.8273 12.5744C14.5058 12.363 15.2392 12.6137 15.6642 13.2022C15.9716 13.6277 15.8464 14.2372 15.3987 14.4955L9.13575 18.1091C8.73742 18.3389 8.26745 18.395 7.8293 18.265L2.5 16.6836"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </a>
                        @endif
                    </div>
                </div>
            </div>
            <div class="card custom--card mb-4">
                <div class="card-body">
                    <div class="row g-3">
                      
                        @if (moduleIsEnable('utility_bill', $enableModules))
                            <div class="col-xsm-6 col-sm-6 col-lg-3">
                                <a href="{{ route('user.utility.bill.create') }}" class="dashboard-widget">
                                    <div class="dashboard-widget__link">
                                        <i class="fas fa-arrow-right"></i>
                                    </div>
                                    <div class="dashboard-widget__icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                            viewBox="0 0 40 40" fill="none">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M20.0007 2.08301C18.5572 2.08301 17.2668 2.54447 15.8737 3.32624C14.5238 4.08372 12.9771 5.20209 11.0321 6.60841L8.51705 8.42688C6.95615 9.55544 5.70945 10.4568 4.76914 11.2911C3.79824 12.1526 3.07189 13.0113 2.61115 14.0916C2.1494 15.1742 2.03774 16.2838 2.09967 17.5632C2.15945 18.7978 2.38839 20.2875 2.67387 22.145L3.19929 25.5642C3.60492 28.2038 3.9279 30.3057 4.4024 31.9433C4.89305 33.6365 5.58425 34.9808 6.81965 36.0083C8.04994 37.0317 9.51549 37.4873 11.3058 37.7048C13.0473 37.9163 15.2442 37.9163 18.0192 37.9163H18.1027L18.7512 37.9152V32.0732C17.492 31.9897 16.3045 31.3768 15.5598 30.3513L14.9757 29.5468C13.9031 28.0695 13.2562 26.3542 13.1084 24.565L12.9297 22.4027C12.8021 20.8593 14.0332 19.7138 15.4179 19.5935V16.6663C15.4179 15.976 15.9775 15.4163 16.6678 15.4163C17.3582 15.4163 17.9178 15.976 17.9178 16.6663V19.583H22.0845V16.6663C22.0845 15.976 22.6442 15.4163 23.3345 15.4163C24.0248 15.4163 24.5845 15.976 24.5845 16.6663V19.5928C25.9718 19.7102 27.207 20.8568 27.0792 22.4027L26.9005 24.565C26.7527 26.3542 26.1058 28.0695 25.0331 29.5468L24.449 30.3513C23.7031 31.3787 22.5128 31.9917 21.2512 32.0737V37.9103L25.003 37.9033L25.0183 37.903C28.6548 37.8517 31.2388 37.6243 33.1817 36.0083C34.4172 34.9808 35.1083 33.6365 35.599 31.9432C36.0735 30.3057 36.3965 28.2038 36.802 25.5642L37.3275 22.1448C37.613 20.2873 37.8418 18.7978 37.9017 17.5632C37.9637 16.2838 37.852 15.1742 37.3902 14.0916C36.9295 13.0113 36.2032 12.1526 35.2322 11.2911C34.2918 10.4569 33.0453 9.55551 31.4843 8.42697L28.9692 6.60839C27.0242 5.20207 25.4775 4.08372 24.1277 3.32624C22.7345 2.54447 21.4442 2.08301 20.0007 2.08301Z"
                                                fill="currentColor" />
                                        </svg>
                                    </div>
                                    <div class="dashboard-widget__content">
                                        <h5 class="dashboard-widget__title">@lang('Bill Pay')</h5>
                                        <span class="dashboard-widget__text">
                                            @lang('Pay utility bills securely online')
                                        </span>
                                    </div>
                                    <div class="dashboard-widget__shape">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                            viewBox="0 0 40 40" fill="none">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M20.0007 2.08301C18.5572 2.08301 17.2668 2.54447 15.8737 3.32624C14.5238 4.08372 12.9771 5.20209 11.0321 6.60841L8.51705 8.42688C6.95615 9.55544 5.70945 10.4568 4.76914 11.2911C3.79824 12.1526 3.07189 13.0113 2.61115 14.0916C2.1494 15.1742 2.03774 16.2838 2.09967 17.5632C2.15945 18.7978 2.38839 20.2875 2.67387 22.145L3.19929 25.5642C3.60492 28.2038 3.9279 30.3057 4.4024 31.9433C4.89305 33.6365 5.58425 34.9808 6.81965 36.0083C8.04994 37.0317 9.51549 37.4873 11.3058 37.7048C13.0473 37.9163 15.2442 37.9163 18.0192 37.9163H18.1027L18.7512 37.9152V32.0732C17.492 31.9897 16.3045 31.3768 15.5598 30.3513L14.9757 29.5468C13.9031 28.0695 13.2562 26.3542 13.1084 24.565L12.9297 22.4027C12.8021 20.8593 14.0332 19.7138 15.4179 19.5935V16.6663C15.4179 15.976 15.9775 15.4163 16.6678 15.4163C17.3582 15.4163 17.9178 15.976 17.9178 16.6663V19.583H22.0845V16.6663C22.0845 15.976 22.6442 15.4163 23.3345 15.4163C24.0248 15.4163 24.5845 15.976 24.5845 16.6663V19.5928C25.9718 19.7102 27.207 20.8568 27.0792 22.4027L26.9005 24.565C26.7527 26.3542 26.1058 28.0695 25.0331 29.5468L24.449 30.3513C23.7031 31.3787 22.5128 31.9917 21.2512 32.0737V37.9103L25.003 37.9033L25.0183 37.903C28.6548 37.8517 31.2388 37.6243 33.1817 36.0083C34.4172 34.9808 35.1083 33.6365 35.599 31.9432C36.0735 30.3057 36.3965 28.2038 36.802 25.5642L37.3275 22.1448C37.613 20.2873 37.8418 18.7978 37.9017 17.5632C37.9637 16.2838 37.852 15.1742 37.3902 14.0916C36.9295 13.0113 36.2032 12.1526 35.2322 11.2911C34.2918 10.4569 33.0453 9.55551 31.4843 8.42697L28.9692 6.60839C27.0242 5.20207 25.4775 4.08372 24.1277 3.32624C22.7345 2.54447 21.4442 2.08301 20.0007 2.08301Z"
                                                fill="currentColor" />
                                        </svg>
                                    </div>
                                </a>
                            </div>
                        @endif
                        @if (moduleIsEnable('education_fee', $enableModules))
                            <div class="col-xsm-6 col-sm-6 col-lg-3">
                                <a href="{{ route('user.education.fee.create') }}" class="dashboard-widget">
                                    <div class="dashboard-widget__link">
                                        <i class="fas fa-arrow-right"></i>
                                    </div>
                                    <div class="dashboard-widget__icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                            viewBox="0 0 40 40" fill="none">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                                fill="currentColor" />
                                            <path
                                                d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                                fill="currentColor" />
                                        </svg>

                                    </div>
                                    <div class="dashboard-widget__content">
                                        <h5 class="dashboard-widget__title">@lang('Education')</h5>
                                        <span class="dashboard-widget__text">
                                            @lang('Pay your education fee with edge.')
                                        </span>
                                    </div>
                                    <div class="dashboard-widget__shape">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                            viewBox="0 0 40 40" fill="none">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M9.70307 10.5839L10.214 10H29.7862L30.297 10.5839C31.7794 12.277 32.7374 13.3713 33.2442 14.7203C33.751 16.0693 33.7507 17.5237 33.7502 19.774L33.75 26.7582C33.75 29.0373 33.7502 30.8745 33.5559 32.3195C33.3542 33.8197 32.9227 35.0828 31.9195 36.086C30.9164 37.0892 29.6532 37.5207 28.153 37.7223C26.708 37.9167 24.8709 37.9167 22.5915 37.9165H17.4087C15.1293 37.9167 13.2921 37.9167 11.8472 37.7223C10.347 37.5207 9.08386 37.0892 8.08067 36.086C7.07747 35.0828 6.64599 33.8197 6.44429 32.3195C6.25002 30.8745 6.25004 29.0373 6.25009 26.758L6.25004 19.774C6.24946 17.5237 6.24907 16.0693 6.75594 14.7203C7.26281 13.3713 8.22079 12.277 9.70307 10.5839ZM21.2017 17.0833C21.2017 16.393 20.642 15.8333 19.9517 15.8333C19.2614 15.8333 18.7017 16.393 18.7017 17.0833V17.6177C18.3674 17.697 18.0354 17.8108 17.7109 17.9628C15.8127 18.8522 14.6656 20.5815 14.9193 22.3783C15.1856 24.2643 16.8697 25.5068 19.1699 25.6235C19.545 25.6425 19.8635 25.6497 20.1489 25.6562C20.6217 25.6667 21.0035 25.6753 21.4019 25.7323C21.9432 25.8098 22.2522 25.956 22.4917 26.2157C22.7472 26.4925 22.9814 27.0852 22.9004 27.6498C22.8377 28.0873 22.5695 28.6472 21.509 28.9842C20.3454 29.3538 19.1634 29.2035 18.2974 28.7805C17.3849 28.3347 17.0834 27.7483 17.0834 27.3885C17.0834 26.6982 16.5237 26.1385 15.8333 26.1385C15.143 26.1385 14.5833 26.6982 14.5833 27.3885C14.5833 29.0778 15.8266 30.3558 17.2002 31.0268C17.6612 31.252 18.167 31.4272 18.7017 31.5413V32.0833C18.7017 32.7737 19.2614 33.3333 19.9517 33.3333C20.642 33.3333 21.2017 32.7737 21.2017 32.0833V31.615C21.5559 31.5613 21.9119 31.4793 22.266 31.3667C24.17 30.7617 25.166 29.4628 25.3752 28.0047C25.5659 26.6735 25.0794 25.3335 24.3292 24.5205C23.5632 23.6902 22.6294 23.3827 21.7564 23.2577C21.2179 23.1805 20.5762 23.1643 20.0017 23.1498C19.7487 23.1435 19.5089 23.1375 19.2964 23.1267C17.7947 23.0505 17.4435 22.3742 17.3947 22.0287C17.3334 21.594 17.5912 20.7797 18.7714 20.2267C19.5282 19.8722 20.4439 19.9055 21.2245 20.2323C22.0414 20.5745 22.4342 21.1058 22.4999 21.4712C22.622 22.1507 23.2719 22.6023 23.9514 22.4803C24.6309 22.3582 25.0825 21.7083 24.9605 21.0288C24.6925 19.5378 23.47 18.4625 22.1904 17.9265C21.878 17.7957 21.5462 17.6893 21.2017 17.6128V17.0833Z"
                                                fill="currentColor" />
                                            <path
                                                d="M12.4433 2.08302H27.5581C27.9 2.08289 28.2696 2.08274 28.5816 2.12469C28.9471 2.17384 29.4141 2.30022 29.8071 2.69322C30.2001 3.08622 30.3265 3.55321 30.3756 3.91876C30.4176 4.23077 30.4175 4.71524 30.4173 5.05711C30.4175 5.39896 30.4176 5.76864 30.3756 6.08066C30.3265 6.44619 30.2001 6.91317 29.8071 7.30617C29.4141 7.69917 28.9471 7.82557 28.5816 7.87471C28.2696 7.91667 27.9 7.91652 27.5581 7.91639H12.4433C12.1014 7.91652 11.7317 7.91667 11.4197 7.87471C11.0542 7.82557 10.5872 7.69917 10.1942 7.30617C9.8012 6.91317 9.67482 6.44619 9.62567 6.08066C9.58372 5.76862 9.58387 5.39897 9.584 5.05712C9.58387 4.71527 9.58372 4.23077 9.62567 3.91876C9.67482 3.55321 9.8012 3.08622 10.1942 2.69322C10.5872 2.30022 11.0542 2.17384 11.4197 2.12469C11.7317 2.08274 12.1014 2.08289 12.4433 2.08302Z"
                                                fill="currentColor" />
                                        </svg>
                                    </div>
                                </a>
                            </div>
                        @endif
                        @if (moduleIsEnable('donation', $enableModules))
                            <div class="col-xsm-6 col-sm-6 col-lg-3">
                                <a href="{{ route('user.donation.create') }}" class="dashboard-widget">
                                    <div class="dashboard-widget__link">
                                        <i class="fas fa-arrow-right"></i>
                                    </div>
                                    <div class="dashboard-widget__icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                            viewBox="0 0 40 40" fill="none">
                                            <path
                                                d="M9.37337 10.9737C9.7563 11.5482 9.60109 12.3242 9.02669 12.7072L6.99535 14.0614C6.24815 14.5595 5.75929 14.887 5.40177 15.1769C5.06455 15.4504 4.91785 15.6338 4.82619 15.8058C4.78955 15.8745 4.75639 15.9511 4.72724 16.0457L15.4982 22.5083C16.773 23.2733 17.6507 23.7981 18.38 24.1409C19.0837 24.4718 19.5559 24.5861 20 24.5861C20.4442 24.5861 20.9164 24.4718 21.62 24.1409C22.3494 23.7981 23.227 23.2733 24.5019 22.5083L35.2727 16.0458C35.2435 15.9511 35.2104 15.8745 35.1737 15.8058C35.082 15.6338 34.9354 15.4504 34.5982 15.1769C34.2407 14.887 33.7519 14.5595 33.0045 14.0614L30.9732 12.7072C30.3989 12.3242 30.2437 11.5482 30.6265 10.9737C31.0095 10.3993 31.7857 10.2441 32.36 10.6271L34.4369 12.0116C35.1262 12.4711 35.7137 12.8628 36.1729 13.2352C36.6624 13.6321 37.077 14.0616 37.3799 14.6298C37.7142 15.2569 37.8325 15.9022 37.8804 16.6018C37.9175 17.1436 37.9154 17.7863 37.9129 18.5314L37.9127 18.5723C37.9057 20.6716 37.886 22.8161 37.8319 24.9886L37.8295 25.0859C37.7677 27.5653 37.7177 29.5654 37.4339 31.1748C37.136 32.8638 36.5639 34.2383 35.3904 35.4118C34.2144 36.5878 32.8289 37.1589 31.1255 37.4564C29.4999 37.7404 27.4747 37.7909 24.9604 37.8538L24.8634 37.8563C21.6115 37.9374 18.3885 37.9374 15.1367 37.8563L15.0396 37.8538C12.5253 37.7909 10.5002 37.7404 8.87455 37.4564C7.1711 37.1589 5.78564 36.5878 4.60969 35.4118C3.43619 34.2383 2.86399 32.8638 2.5661 31.1748C2.28227 29.5654 2.23239 27.5653 2.17054 25.0859L2.1681 24.9886C2.11387 22.8161 2.09435 20.6718 2.08729 18.5723L2.08715 18.5318C2.08464 17.7864 2.08247 17.1436 2.11957 16.6017C2.16745 15.9022 2.28577 15.2569 2.62002 14.6298C2.92292 14.0616 3.33755 13.6321 3.82709 13.2352C4.28624 12.8628 4.87374 12.4712 5.56305 12.0116L7.63994 10.6271C8.21434 10.2441 8.99044 10.3993 9.37337 10.9737Z"
                                                fill="currentColor" />
                                            <path
                                                d="M25.0873 2.08301C26.5848 2.08296 27.8335 2.08293 28.8248 2.21619C29.8712 2.35688 30.8158 2.66633 31.5748 3.42544C32.334 4.18456 32.6435 5.12923 32.7842 6.17554C32.9175 7.16684 32.9173 8.41553 32.9173 9.91298V19.9997C32.9173 20.69 32.3577 21.2497 31.6673 21.2497C30.977 21.2497 30.4173 20.69 30.4173 19.9997V9.99968C30.4173 8.39299 30.4147 7.31373 30.3065 6.50866C30.203 5.73956 30.0243 5.41041 29.8072 5.19321C29.59 4.97601 29.2608 4.79731 28.4917 4.69391C27.6867 4.58568 26.6073 4.58301 25.0007 4.58301H15.0007C13.394 4.58301 12.3147 4.58568 11.5096 4.69391C10.7405 4.79731 10.4114 4.97601 10.1942 5.19321C9.97699 5.41041 9.79829 5.73956 9.69489 6.50866C9.58665 7.31373 9.58399 8.39299 9.58399 9.99968V19.9997C9.58399 20.69 9.02435 21.2497 8.33399 21.2497C7.64364 21.2497 7.08399 20.69 7.08399 19.9997V9.91301C7.08394 8.41556 7.0839 7.16684 7.21717 6.17554C7.35785 5.12923 7.6673 4.18456 8.42642 3.42544C9.18554 2.66633 10.1302 2.35688 11.1765 2.21619C12.1678 2.08293 13.4165 2.08296 14.9139 2.08301H25.0873Z"
                                                fill="currentColor" />
                                            <path
                                                d="M15.6548 9.37372C17.358 8.40639 18.9505 8.69915 20.0035 9.34062C21.0563 8.69915 22.6488 8.40639 24.352 9.37372C25.7363 10.16 26.455 11.7724 26.2032 13.5106C25.9512 15.2512 24.7645 17.0457 22.5403 18.57L22.4375 18.6407C21.7498 19.1138 21.0668 19.5837 20.0035 19.5837C18.94 19.5837 18.257 19.1138 17.5693 18.6407L17.4665 18.57C15.2424 17.0457 14.0557 15.2512 13.8036 13.5106C13.5518 11.7724 14.2705 10.16 15.6548 9.37372Z"
                                                fill="currentColor" />
                                        </svg>
                                    </div>
                                    <div class="dashboard-widget__content">
                                        <h5 class="dashboard-widget__title">@lang('Donation')</h5>
                                        <span class="dashboard-widget__text">
                                            @lang('Support causes with one click.')
                                        </span>
                                    </div>
                                    <div class="dashboard-widget__shape">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                            viewBox="0 0 40 40" fill="none">
                                            <path
                                                d="M9.37337 10.9737C9.7563 11.5482 9.60109 12.3242 9.02669 12.7072L6.99535 14.0614C6.24815 14.5595 5.75929 14.887 5.40177 15.1769C5.06455 15.4504 4.91785 15.6338 4.82619 15.8058C4.78955 15.8745 4.75639 15.9511 4.72724 16.0457L15.4982 22.5083C16.773 23.2733 17.6507 23.7981 18.38 24.1409C19.0837 24.4718 19.5559 24.5861 20 24.5861C20.4442 24.5861 20.9164 24.4718 21.62 24.1409C22.3494 23.7981 23.227 23.2733 24.5019 22.5083L35.2727 16.0458C35.2435 15.9511 35.2104 15.8745 35.1737 15.8058C35.082 15.6338 34.9354 15.4504 34.5982 15.1769C34.2407 14.887 33.7519 14.5595 33.0045 14.0614L30.9732 12.7072C30.3989 12.3242 30.2437 11.5482 30.6265 10.9737C31.0095 10.3993 31.7857 10.2441 32.36 10.6271L34.4369 12.0116C35.1262 12.4711 35.7137 12.8628 36.1729 13.2352C36.6624 13.6321 37.077 14.0616 37.3799 14.6298C37.7142 15.2569 37.8325 15.9022 37.8804 16.6018C37.9175 17.1436 37.9154 17.7863 37.9129 18.5314L37.9127 18.5723C37.9057 20.6716 37.886 22.8161 37.8319 24.9886L37.8295 25.0859C37.7677 27.5653 37.7177 29.5654 37.4339 31.1748C37.136 32.8638 36.5639 34.2383 35.3904 35.4118C34.2144 36.5878 32.8289 37.1589 31.1255 37.4564C29.4999 37.7404 27.4747 37.7909 24.9604 37.8538L24.8634 37.8563C21.6115 37.9374 18.3885 37.9374 15.1367 37.8563L15.0396 37.8538C12.5253 37.7909 10.5002 37.7404 8.87455 37.4564C7.1711 37.1589 5.78564 36.5878 4.60969 35.4118C3.43619 34.2383 2.86399 32.8638 2.5661 31.1748C2.28227 29.5654 2.23239 27.5653 2.17054 25.0859L2.1681 24.9886C2.11387 22.8161 2.09435 20.6718 2.08729 18.5723L2.08715 18.5318C2.08464 17.7864 2.08247 17.1436 2.11957 16.6017C2.16745 15.9022 2.28577 15.2569 2.62002 14.6298C2.92292 14.0616 3.33755 13.6321 3.82709 13.2352C4.28624 12.8628 4.87374 12.4712 5.56305 12.0116L7.63994 10.6271C8.21434 10.2441 8.99044 10.3993 9.37337 10.9737Z"
                                                fill="currentColor" />
                                            <path
                                                d="M25.0873 2.08301C26.5848 2.08296 27.8335 2.08293 28.8248 2.21619C29.8712 2.35688 30.8158 2.66633 31.5748 3.42544C32.334 4.18456 32.6435 5.12923 32.7842 6.17554C32.9175 7.16684 32.9173 8.41553 32.9173 9.91298V19.9997C32.9173 20.69 32.3577 21.2497 31.6673 21.2497C30.977 21.2497 30.4173 20.69 30.4173 19.9997V9.99968C30.4173 8.39299 30.4147 7.31373 30.3065 6.50866C30.203 5.73956 30.0243 5.41041 29.8072 5.19321C29.59 4.97601 29.2608 4.79731 28.4917 4.69391C27.6867 4.58568 26.6073 4.58301 25.0007 4.58301H15.0007C13.394 4.58301 12.3147 4.58568 11.5096 4.69391C10.7405 4.79731 10.4114 4.97601 10.1942 5.19321C9.97699 5.41041 9.79829 5.73956 9.69489 6.50866C9.58665 7.31373 9.58399 8.39299 9.58399 9.99968V19.9997C9.58399 20.69 9.02435 21.2497 8.33399 21.2497C7.64364 21.2497 7.08399 20.69 7.08399 19.9997V9.91301C7.08394 8.41556 7.0839 7.16684 7.21717 6.17554C7.35785 5.12923 7.6673 4.18456 8.42642 3.42544C9.18554 2.66633 10.1302 2.35688 11.1765 2.21619C12.1678 2.08293 13.4165 2.08296 14.9139 2.08301H25.0873Z"
                                                fill="currentColor" />
                                            <path
                                                d="M15.6548 9.37372C17.358 8.40639 18.9505 8.69915 20.0035 9.34062C21.0563 8.69915 22.6488 8.40639 24.352 9.37372C25.7363 10.16 26.455 11.7724 26.2032 13.5106C25.9512 15.2512 24.7645 17.0457 22.5403 18.57L22.4375 18.6407C21.7498 19.1138 21.0668 19.5837 20.0035 19.5837C18.94 19.5837 18.257 19.1138 17.5693 18.6407L17.4665 18.57C15.2424 17.0457 14.0557 15.2512 13.8036 13.5106C13.5518 11.7724 14.2705 10.16 15.6548 9.37372Z"
                                                fill="currentColor" />
                                        </svg>
                                    </div>
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="table-wrapper">
                <div class="table-wrapper-header">
                    <h4>@lang('Latest Transactions')</h4>
                    <form class="table-search-right no-submit-loader">
                        <div class="table-search style-two">
                            <input type="text" name="search" class="form--control"
                                placeholder="@lang('Search Here')..." value="{{ request()->search }}">
                            <button type="submit" class="icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none">
                                    <path
                                        d="M11 19C15.4183 19 19 15.4183 19 11C19 6.58172 15.4183 3 11 3C6.58172 3 3 6.58172 3 11C3 15.4183 6.58172 19 11 19Z"
                                        stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path d="M20.9992 21.0002L16.6992 16.7002" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="table-wrapper-body">
                    <table class="table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Trx')</th>
                                <th>@lang('Transacted')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Charge')</th>
                                <th>@lang('Post Balance')</th>
                                <th>@lang('Detail')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactions as $trx)
                                <tr>
                                    <td>
                                        <strong>{{ $trx->trx }}</strong>
                                    </td>
                                    <td>
                                        {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                                    </td>
                                    <td>
                                        <span
                                            class="fw-bold @if ($trx->trx_type == '+') text--success @else text--danger @endif">
                                            {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                                        </span>
                                    </td>
                                    <td>
                                        {{ showAmount($trx->charge) }}
                                    </td>
                                    <td>
                                        {{ showAmount($trx->post_balance) }}
                                    </td>
                                    <td>{{ __($trx->details) }}</td>
                                </tr>
                            @empty
                                @include('Template::partials.empty_message')
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="table-wrapper-footer d-none"></div>
            </div>
        </div>
    </div>


    @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
        <div class="modal fade custom--modal" id="kycRejectionReason">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>{{ auth()->user()->kyc_rejection_reason }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif


    <div class="modal custom--modal fade qr-modal" id="qr-modal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-img "
                    data-background-image="{{ asset($activeTemplateTrue . 'images/modal_shape.png') }}">
                    <h4 class="modal-title">@lang('My QR Code')</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="qr-modal-thumb text-center">
                        <img class="mx-auto" src="{{ $qrCodeUrl }}" alt="QR">
                    </div>
                    <p class="qr-modal-note fs-14">
                        <i>
                            @lang('Scan this QR code to make your transactions quick and easy!')
                        </i>
                    </p>
                    <div class="qr-modal-form mt-4 mb-4">
                        <h6 class="title">@lang('My Number')</h6>
                        <div class="number">
                            @foreach (str_split(auth()->user()->mobile) as $digit)
                                <span>{{ $digit }}</span>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-img justify-content-center"
                    data-background-image="{{ asset($activeTemplateTrue . 'images/modal_shape.png') }}">
                    <h4 class="">{{ __(gs('site_name')) }}</h4>
                </div>
            </div>
        </div>
    </div>
@endsection
