<div class="row">
    <div class="col-xxl-5 col-xl-7 col-md-8">
        <div class="card custom--card">
            <div class="card-header">
                <div class="payment-info-top">
                    <span class="icon">
                        <img src="{{ asset($activeTemplateTrue . 'images/success.png') }}" alt="image">
                    </span>
                    <div class="content">
                        <h4 class="title">@lang('Gift Card Purchase Successful!')</h4>
                        <p class="desc">@lang('Your gift card purchase has been successfully done.')</p>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="payment-info">
                    <div class="payment-info-item">
                        <span class="title">@lang('Gift Card')</span>
                        <span class="desc">{{ $giftCardPurchase->giftCard->product_name }}</span>
                    </div>
                    <div class="payment-info-item">
                        <span class="title">@lang('Recipient')</span>
                        <span class="desc">{{ $giftCardPurchase->recipient_email }}</span>
                    </div>
                    <div class="payment-info-item">
                        <span class="title">@lang('TRX ID')</span>
                        <span class="desc">{{ $giftCardPurchase->trx }}</span>
                    </div>
                    <div class="payment-info-item">
                        <span class="title">@lang('Time')</span>
                        <span class="desc">{{ showDateTime($giftCardPurchase->created_at) }}</span>
                    </div>
                    <div class="payment-info-item">
                        <span class="title">@lang('Unit Price')</span>
                        <span class="desc">
                            <span class="d-block">
                                {{ getAmount(@$giftCardPurchase->unit_price) }}
                                {{ @$giftCardPurchase->giftCard->sender_currency_code }}
                                ({{ getAmount($giftCardPurchase->amount) }}
                                {{ @$giftCardPurchase->giftCard->recipient_currency_code }})
                            </span>
                        </span>
                    </div>
                    <div class="payment-info-item">
                        <span class="title">@lang('Quantity')</span>
                        <span class="desc">{{ $giftCardPurchase->quantity }}</span>
                    </div>
                    <div class="payment-info-item">
                        <span class="title">@lang('Subtotal')</span>
                        <span class="desc">{{ showAmount($giftCardPurchase->sub_total) }}</span>
                    </div>
                    <div class="payment-info-item">
                        <span class="title">@lang('Fee') (+)</span>
                        <span class="desc">{{ showAmount($giftCardPurchase->charge) }}</span>
                    </div>
                    @if ($giftCardPurchase->discount > 0)
                        <div class="payment-info-item">
                            <span class="title">@lang('Discount') (-)</span>
                            <span class="desc">{{ showAmount($giftCardPurchase->discount) }}</span>
                        </div>
                    @endif
                    <div class="payment-info-item total">
                        <span class="title">@lang('Total')</span>
                        <span class="desc">{{ showAmount($giftCardPurchase->total) }}</span>
                    </div>
                    <div class="payment-info-item total">
                        <span class="title">@lang('Status')</span>
                        @php echo $giftCardPurchase->statusBadge @endphp
                    </div>
                </div>
                <div class="payment-btn-wrapper flex-align gap-3 gap-lg-4 mt-4">
                    <a href="{{ route('user.gift.card.history') }}" class="btn btn--light flex-grow-1">
                        <span class="icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path
                                    d="M5.04271 1.04199C5.79143 1.04197 6.41577 1.04195 6.91142 1.10858C7.43458 1.17893 7.90692 1.33365 8.28647 1.71321C8.66602 2.09277 8.82077 2.5651 8.8911 3.08826C8.95777 3.58391 8.95768 4.20825 8.95768 4.95698V6.71033C8.95768 7.45905 8.95777 8.08342 8.8911 8.57908C8.82077 9.10224 8.66602 9.57458 8.28647 9.95408C7.90692 10.3337 7.43458 10.4884 6.91142 10.5587C6.41577 10.6254 5.79143 10.6253 5.04271 10.6253H4.95602C4.2073 10.6253 3.58293 10.6254 3.08728 10.5587C2.56412 10.4884 2.09179 10.3337 1.71223 9.95408C1.33267 9.57458 1.17795 9.10224 1.10761 8.57908C1.04097 8.08342 1.04099 7.45908 1.04102 6.71035V4.95699C1.04099 4.20828 1.04097 3.58391 1.10761 3.08826C1.17795 2.5651 1.33267 2.09277 1.71223 1.71321C2.09179 1.33365 2.56412 1.17893 3.08728 1.10858C3.58293 1.04195 4.20727 1.04197 4.95599 1.04199H5.04271Z"
                                    fill="currentColor" />
                                <path
                                    d="M5.85373 12.708C6.22412 12.708 6.53331 12.708 6.78716 12.7253C7.05141 12.7433 7.30101 12.7822 7.543 12.8824C8.10452 13.115 8.55068 13.5612 8.78327 14.1227C8.88352 14.3647 8.92235 14.6143 8.94035 14.8785C8.95768 15.1323 8.95768 15.4416 8.95768 15.8119V15.8541C8.95768 16.2244 8.95768 16.5337 8.94035 16.7875C8.92235 17.0518 8.88352 17.3013 8.78327 17.5433C8.55068 18.1048 8.10452 18.551 7.543 18.7836C7.30101 18.8838 7.05141 18.9227 6.78716 18.9407C6.53331 18.958 6.22412 18.958 5.85373 18.958H4.14497C3.77458 18.958 3.46539 18.958 3.21155 18.9407C2.9473 18.9227 2.69769 18.8838 2.4557 18.7836C1.89417 18.551 1.44805 18.1048 1.21546 17.5433C1.11522 17.3013 1.07636 17.0518 1.05832 16.7875C1.04101 16.5337 1.04101 16.2244 1.04102 15.8541V15.8119C1.04101 15.4416 1.04101 15.1323 1.05832 14.8785C1.07636 14.6143 1.11522 14.3647 1.21546 14.1227C1.44805 13.5612 1.89417 13.115 2.4557 12.8824C2.69769 12.7822 2.9473 12.7433 3.21155 12.7253C3.46539 12.708 3.77458 12.708 4.14497 12.708H5.85373Z"
                                    fill="currentColor" />
                                <path
                                    d="M15.0427 9.375C15.7914 9.375 16.4158 9.37492 16.9114 9.44158C17.4346 9.51192 17.9069 9.66667 18.2864 10.0463C18.666 10.4258 18.8208 10.8981 18.8911 11.4212C18.9578 11.9169 18.9577 12.5412 18.9577 13.29V15.0433C18.9577 15.7921 18.9578 16.4164 18.8911 16.9121C18.8208 17.4353 18.666 17.9076 18.2864 18.2871C17.9069 18.6667 17.4346 18.8214 16.9114 18.8917C16.4158 18.9584 15.7914 18.9583 15.0427 18.9583H14.956C14.2073 18.9583 13.5829 18.9584 13.0873 18.8917C12.5641 18.8214 12.0918 18.6667 11.7123 18.2871C11.3327 17.9076 11.1779 17.4353 11.1076 16.9121C11.0409 16.4164 11.041 15.7921 11.041 15.0433V13.29C11.041 12.5412 11.0409 11.9169 11.1076 11.4212C11.1779 10.8981 11.3327 10.4258 11.7123 10.0463C12.0918 9.66667 12.5641 9.51192 13.0873 9.44158C13.5829 9.37492 14.2073 9.375 14.956 9.375H15.0427Z"
                                    fill="currentColor" />
                                <path
                                    d="M15.8538 1.04199C16.2241 1.04198 16.5333 1.04198 16.7872 1.0593C17.0514 1.07733 17.301 1.1162 17.543 1.21643C18.1045 1.44903 18.5507 1.89515 18.7833 2.45668C18.8835 2.69867 18.9223 2.94828 18.9403 3.21253C18.9577 3.46637 18.9577 3.77556 18.9577 4.14594V4.18804C18.9577 4.55843 18.9577 4.86762 18.9403 5.12147C18.9223 5.38572 18.8835 5.63532 18.7833 5.87731C18.5507 6.43883 18.1045 6.88496 17.543 7.11755C17.301 7.21778 17.0514 7.25666 16.7872 7.27468C16.5333 7.292 16.2241 7.292 15.8538 7.29199H14.1449C13.7746 7.292 13.4653 7.292 13.2115 7.27468C12.9473 7.25666 12.6977 7.21778 12.4557 7.11755C11.8942 6.88496 11.448 6.43883 11.2154 5.87731C11.1152 5.63532 11.0763 5.38572 11.0583 5.12147C11.041 4.86762 11.041 4.55843 11.041 4.18804V4.14595C11.041 3.77557 11.041 3.46637 11.0583 3.21253C11.0763 2.94828 11.1152 2.69867 11.2154 2.45668C11.448 1.89515 11.8942 1.44903 12.4557 1.21643C12.6977 1.1162 12.9473 1.07733 13.2115 1.0593C13.4653 1.04198 13.7746 1.04198 14.1449 1.04199H15.8538Z"
                                    fill="currentColor" />
                            </svg>

                        </span>
                        @lang('Gift Card Purchase History')
                    </a>


                    <a href="{{ route('user.gift.card.pdf', $giftCardPurchase->id) }}" class="btn btn--base flex-grow-1">
                        <span class="icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path
                                    d="M3.33398 15.5385V6.71221C3.33398 4.33387 3.33398 3.1447 4.06622 2.40585C4.79845 1.66699 5.97696 1.66699 8.33398 1.66699H11.6673C14.0243 1.66699 15.2028 1.66699 15.9351 2.40585C16.6673 3.1447 16.6673 4.33387 16.6673 6.71221V15.5385C16.6673 16.7982 16.6673 17.4281 16.2823 17.676C15.6532 18.0812 14.6807 17.2315 14.1916 16.9231C13.7874 16.6682 13.5854 16.5407 13.3611 16.5334C13.1187 16.5254 12.9131 16.6477 12.4764 16.9231L10.884 17.9273C10.4544 18.1982 10.2397 18.3337 10.0007 18.3337C9.76165 18.3337 9.5469 18.1982 9.11732 17.9273L7.52493 16.9231C7.12078 16.6682 6.9187 16.5407 6.69443 16.5334C6.45208 16.5254 6.24643 16.6477 5.80971 16.9231C5.32061 17.2315 4.34804 18.0812 3.71894 17.676C3.33398 17.4281 3.33398 16.7982 3.33398 15.5385Z"
                                    stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                <path d="M13.3327 5H6.66602" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                <path d="M8.33268 8.33301H6.66602" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                <path
                                    d="M12.084 8.22917C11.3937 8.22917 10.834 8.71883 10.834 9.32292C10.834 9.927 11.3937 10.4167 12.084 10.4167C12.7743 10.4167 13.334 10.9063 13.334 11.5104C13.334 12.1145 12.7743 12.6042 12.084 12.6042M12.084 8.22917C12.6282 8.22917 13.0912 8.5335 13.2628 8.95833M12.084 8.22917V7.5M12.084 12.6042C11.5397 12.6042 11.0767 12.2998 10.9052 11.875M12.084 12.6042V13.3333"
                                    stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                            </svg>
                        </span>
                        @lang('Download Receipt')
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
